from django.shortcuts import render_to_response
from django.contrib.auth.decorators import login_required
from django.template import RequestContext
from ldt.ldt_utils.models import Content, Project


@login_required
def workspace(request):

    # list of contents
    content_list = Content.objects.all()

    # get list of projects
    project_list = Project.objects.filter(state=2)

    # render list
    return render_to_response("eulalie/workspace.html", 
                              {'contents': content_list, 'projects': project_list},
                              context_instance=RequestContext(request))
