from django.db import models
from django.contrib.auth.models import User, Group, UserManager
from django.utils.translation import gettext as _
from django.contrib import admin
import datetime


class IriGroup(Group):
    description = models.TextField(null=True, blank=True)
    
    def __unicode__(self):
        return self.name

            
class ldt(User):
    irigroups = models.ManyToManyField(IriGroup, blank=True)
    
    class Meta:
        verbose_name = 'iri user'
        verbose_name_plural = 'iri users'
    
    def __unicode__(self):
        return self.username
        

class ldtManager(UserManager):
    def create_user(self, username, email, password=None):
        "Creates and saves a User with the given username, e-mail and password."
        now = datetime.datetime.now()
        user = ldt(None, username, '', '', email.strip().lower(), 'placeholder', False, True, False, now, now)
        if password:
            user.set_password(password)
        else:
            user.set_unusable_password()
        user.save()
        return user   

User.objects = ldtManager()
User.objects.contribute_to_class(User, "objects")

admin.site.register(ldt)
admin.site.register(IriGroup)
