from django.shortcuts import render_to_response
from django.contrib.auth.decorators import login_required
from django.template import RequestContext
from django.utils.html import escape
from django.template.loader import render_to_string
from ldt.ldt_utils.models import Content, Project


@login_required
def workspace(request):

    # list of contents
    content_list = Content.objects.all()

    # get list of projects
    project_list = Project.objects.filter(state=2)

    # render list
    return render_to_response("eulalie/workspace.html", 
                              {'contents': content_list, 'projects': project_list},
                              context_instance=RequestContext(request))
    
def popup_embed(request):
    
    json_url = request.GET.get("json_url")
    player_id = request.GET.get("player_id")
    
    
    embed_rendered = escape(render_to_string('eulalie/partial/embed.html', {'json_url':json_url,'player_id':player_id}, context_instance=RequestContext(request)))

    
    return render_to_response("eulalie/embed_popup.html",
                              {'json_url':json_url,'player_id':player_id, 'player_embed_rendered':embed_rendered},
                              context_instance=RequestContext(request)) 
