<?php
/*
	Plugin Name: Twitter Widget
	Description: Twitter widget.
	Author: PEGO
	Version: 1.0
	Author URI:  
*/
class twitter_widget extends WP_Widget {
/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
function __construct() {
	$widget_options = array(
		'classname' => 'twitter_widget',
		'description' => __('Custom twitter widget.','pego_tr')
	);
		
	$control_options = array(    //dodama svoje incializirane mere
		'width' => 200,
		'height' => 400,
		'id_base' => 'twitter_widget'
	);
	parent::__construct( 'twitter_widget', __('Twitter Widget','pego_tr'), $widget_options, $control_options );	
}
function widget( $args, $instance ) {
	
	extract( $args );
	$title = apply_filters('widget_title', $instance['title'] );
	$account = $instance['account'];
	$tweets_number = $instance['tweets_number'];

	echo $before_widget;
	// start
		echo '<div id="twitter_div">'
              .$before_title.$title.$after_title;
		echo '<ul id="twitter_update_list"></ul></div>
		      <script type="text/javascript" src="'.get_template_directory_uri().'/js/blogger.js"></script>';
		echo '<script type="text/javascript" src="https://api.twitter.com/1/statuses/user_timeline.json?screen_name='.$account.'&include_rts=true&count='.$tweets_number.'&callback=twitterCallback2"></script>';
	

	echo $after_widget;
}
function form( $instance ) {	
		/* Set the default values  */
		$defaults = array(
		'title' => __('Twitter','pego_tr'),
		'account' => 'designpego',
		'tweets_number' => '3',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );  
	 ?>

		<label for="<?php echo $this->get_field_id( 'title' ); ?>">
		Title:
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" 
				 name="<?php echo $this->get_field_name( 'title' ); ?>" 
				 value="<?php echo $instance['title']; ?>" />
		</label>
		
		<label for="<?php echo $this->get_field_id( 'account' ); ?>">
		Account:
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'account' ); ?>" 
				 name="<?php echo $this->get_field_name( 'account' ); ?>" 
				 value="<?php echo $instance['account']; ?>" />
		</label>
																													
		<label for="<?php echo $this->get_field_id( 'tweets_number' ); ?>">
		Number of tweets:
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'tweets_number' ); ?>" 
				 name="<?php echo $this->get_field_name( 'tweets_number' ); ?>" 
				 value="<?php echo $instance['tweets_number']; ?>" />
		</label>

			
	<?php
	}
}


/*     Adding widget to widgets_init and registering flickr widget    */
add_action( 'widgets_init', 'twitter_widgets' );

function twitter_widgets() {
	register_widget( 'twitter_Widget' );
}
?>