<?php

/*

	Plugin Name: Post Widget
	Description: Plugin is used for posts.
	Author:
	Version: 1.0
	Author URI: 
 
*/

class post_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
function post_Widget() {

	$widget_options = array(
		'classname' => 'post_widget',
		'description' => 'Custom post widget.');

	$control_options = array(    //dodama svoje incializirane mere
		'width' => 200,
		'height' => 400,
		'id_base' => 'post_widget'
	);

	$this->WP_Widget( 'post_widget', 'Post Widget', $widget_options, $control_options );
	
}



function widget( $args, $instance ) {
	
	extract( $args );
	$title = apply_filters('widget_title', $instance['title'] );
	$username = $instance['username'];
	$posts_number = $instance['posts_number'];

	echo $before_widget;
	
	if ( $title )
	{
		echo $before_title;
		echo $title;
		echo $after_title;
	}
	
	$args = array('posts_per_page' => $posts_number, 'order'=> 'DESC', 'orderby' => 'post_date'  );

	$port_query = new WP_Query( $args );
                
   if( $port_query->have_posts() ) : while( $port_query->have_posts() ) : $port_query->the_post(); 
				
						?>
						<div class="fl" style="width:200px;">
							<div class="mypost_widget_img fl"> 
								<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
								<a href="<?php the_permalink();?>">						
									 <img  src="<?php echo get_template_directory_uri(); ?>/functions/crop.php?h=100&w=100&f=<?php echo $image[0]; ?>" /> 
								</a>
							</div>
							<div class="mypost_widget_text fl"> 
							   <a  href="<?php the_permalink();?>"><?php echo get_the_title($post->ID); ?></a>
							   <div class="date"><?php the_time('F j, Y'); ?></div>
							</div>	
						</div>
										
				
	<?php endwhile; endif; wp_reset_postdata(); ?>
	
	<div class="clear"></div>		
	<?php
     
 	
	echo $after_widget;
	
}


function form( $instance ) {  

	/* Set the default values  */
		$defaults = array(
		'title' => 'Post Widget',
		'posts_number' => '3',
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); 

	 ?>

		<label for="<?php echo $this->get_field_id( 'title' ); ?>">
		<?php _e('Title:','pego_tr'); ?>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" 
				 name="<?php echo $this->get_field_name( 'title' ); ?>" 
				 value="<?php echo $instance['title']; ?>" />
		</label>
																													
		<label for="<?php echo $this->get_field_id( 'posts_number' ); ?>">
		<?php _e('Number of posts:','pego_tr'); ?>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'posts_number' ); ?>" 
				 name="<?php echo $this->get_field_name( 'posts_number' ); ?>" 
				 value="<?php echo $instance['posts_number']; ?>" />
		</label>

			
	<?php
	}
}


/*     Adding widget to widgets_init and registering flickr widget    */
add_action( 'widgets_init', 'post_widgets' );

function post_widgets() {
	register_widget( 'post_Widget' );
}
?>