jQuery(document).ready(function($) {

  // get the action filter option item on page load
  var $filterType = $('#filterOptions li.active a').attr('class');
	
  // get and assign the ourHolder element to the
	// $holder varible for use later
  var $holder = $('ul.portfolio-circles');

  // clone all items within the pre-assigned $holder element
  var $data = $holder.clone();

  // attempt to call Quicksand when a filter option
	// item is clicked
	$('#filterOptions li a').click(function(e) {
		// reset the active class on all the buttons
		$('#filterOptions li').removeClass('active');
		
		// assign the class of the clicked filter option
		// element to our $filterType variable
		var $filterType = $(this).attr('class');
		$(this).parent().addClass('active');
		
		if ($filterType == 'all') {
			// assign all li items to the $filteredData var when
			// the 'All' filter option is clicked
			var $filteredData = $data.find('li');
		} 
		else {
			// find all li elements that have our required $filterType
			// values for the data-type element
			var $filteredData = $data.find('li[data-type~=' + $filterType + ']');
		}
		
		// call quicksand and assign transition parameters
		$holder.quicksand($filteredData, {
			duration: 800,
			easing: 'easeInOutQuad',
			enhancement: function() {
			  $(function(){
						$("#portfolio-filter a").bind("mouseenter",function(){	   
						   name = $(this).data("name");	   
						   $('#portfolio-content ul.portfolio-circles').find('.'+name).stop().animate({backgroundPosition: '-170px 0px'},300);
						   
						}).bind("mouseleave",function(){	   
						   name = $(this).data("name");
							$('#portfolio-content ul.portfolio-circles').find('.'+name).stop().animate({backgroundPosition: '0px 0px'},300);
						
						});
						
						$('#portfolio-content ul.portfolio-circles li').bind("mouseenter",function(){
							$(this).find('.circle-p').stop().animate({backgroundPosition: '-170px 0px'},300);
						
						}).bind("mouseleave",function(){
							$(this).find('.circle-p').stop().animate({backgroundPosition: '0px 0px'},300);
						
						});
						
						
						
					});
					
					jQuery(document).ready(function($){
						$("li.all").show();
							
						$("#thumbs a.view, ul.paginate a.view").click(function(){
							var section_id = "#" + $(this).closest(".content-wrapper").attr("id");
							if ($("#portfolio-item-wrapper-container").length > 0){
								slide_empty_portfolio_item();
							}
							$("ul#thumbs li, ul.paginate li").removeClass("active_item");
							$(this).closest("li").addClass("active_item");
							if ($("#portfolio-item-wrapper-container").length < 1){
								if ($(section_id + " .divider-heading").length < 1) {
									$(section_id).prepend("<div id='portfolio-item-wrapper-container' style='display:none'></div>");
								} else {
									$(section_id).find(".divider-heading").after("<div id='portfolio-item-wrapper-container' style='display:none'></div>");
								}
							}
							var url = $(this).attr("href") + " #portfolio-item-wrapper";						        
							show_item_inline(url, "#portfolio-item-wrapper-container", section_id, 600, "");					
						return false
						})
					});
			}
		});
		return false;
	});
});

