<?php
	/* to remove notifications for upgrade wordpress */
	// add_filter( 'pre_site_transient_update_core', create_function( '$a', "return null;" ) );
	add_filter( 'pre_site_transient_update_core', function($a) { return null; });

	load_theme_textdomain('pego_tr',get_template_directory() . '/languages');
		
	$themedir = get_template_directory_uri();
		
	function my_scripts() {
		global $themedir;
		wp_enqueue_script('slides-min-jquery', $themedir . '/js/slides.min.jquery.js','','',true); 					
		wp_enqueue_script('jquery-ui-min', $themedir . '/jquery-ui/jquery-ui.min.js','','',true);
		wp_enqueue_script('jquery-easing', $themedir . '/js/jquery.easing.1.3.js','','',true);
		wp_enqueue_script('jquery-iconmenu', $themedir . '/js/jquery.iconmenu.js','','',true);		
		wp_enqueue_script('jquery-nav-min', $themedir . '/js/jquery.nav.min.js','','',true);						
		wp_enqueue_script('jquery-nav', $themedir . '/js/jquery.nav.js','','',true);									
		wp_enqueue_script('plugins', $themedir . '/js/plugins.js','','',true); 										
		wp_enqueue_script('jquery-quicksand', $themedir . '/js/jquery.quicksand.js','','',true); 						
		wp_enqueue_script('main', $themedir . '/js/main.js','','',true); 												
		wp_enqueue_script('script', $themedir . '/js/script.js','','',true);				
		wp_enqueue_script('jquery-tipsy', $themedir . '/js/jquery.tipsy.js','','',true);  
		wp_enqueue_script('jquery-validate-pack', $themedir . '/js/jquery.validate.min.js','','',true);	
		wp_enqueue_script('jquery-mousewheel', $themedir . '/fancybox/jquery.mousewheel-3.0.4.pack.js','','',true); 	
		wp_enqueue_script('jquery-fancybox-pack', $themedir . '/fancybox/jquery.fancybox.min.js','','',true);		
	}	 
	add_action('init', 'my_scripts');
	
	
	/* specify content width */
	if ( ! isset( $content_width ) ) $content_width = 960;
	
	
	/* code for menus */
	if (function_exists('register_nav_menus')) {
		register_nav_menus (
			array (
				'main_nav' => 'Main Navigation Menu'
			)
		);
	}
	
	// Declare sidebar widget zone
    if (function_exists('register_sidebar')) {
    	register_sidebar(array(
    		'name' => 'Sidebar-1 Widgets',
    		'id'   => 'sidebar-1-widgets',
    		'description'   => 'These are widgets for the sidebar.',
    		'before_widget' => '<div id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</div></div>',
    		'before_title'  => '<h3 class="sidebar-style">',
    		'after_title'   => '</h3><div class="lh15">'
    	));
    }

	/* start footer widgets */
	function new_widgets_init() {		
		register_sidebar(array(
			'name' => 'Footer First Column Sidebar',
			'id' => 'first-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widget-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => 'Footer Second Column Sidebar',
			'id' => 'second-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widget-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => 'Footer  Third Column Sidebar',
			'id' => 'third-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widget-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => 'Footer  Fourth  Column 	Sidebar',
			'id' => 'fourth-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widget-title">',
			'after_title' => '</h4>',
		));
	}
	add_action( 'init', 'new_widgets_init' );
	/* end footer widgets */
	
	
	add_theme_support('post-thumbnails');
	
	
	
	if(!function_exists('getPageTitle'))
		{
			function getPageTitle($pageId)
			{
				if(!is_numeric($pageId))
				{
					return;
				}
				global $wpdb;
				$sql_query = 'SELECT DISTINCT * FROM ' . $wpdb->posts .
				' WHERE ' . $wpdb->posts . '.ID=' . $pageId;
				$posts = $wpdb->get_results($sql_query);
				if(!empty($posts))
				{
					foreach($posts as $post)
				{
					return nl2br($post->post_title);
				}
			}
		}
	}
	
	
	function getPostViews($postID){
		$count_key = 'post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count==''){
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
			return "0 View";
		}
		return $count;
	}
	function setPostViews($postID) {
		$count_key = 'post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count==''){
			$count = 0;
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
		}else{
			$count++;
			update_post_meta($postID, $count_key, $count);
		}
	}	
	function SearchFilter($query) {
	if ($query->is_search) {
	$query->set('post_type', 'post');
	}
	return $query;
	}
	 
	add_filter('pre_get_posts','SearchFilter');
	
	include("functions/widget-posts.php");
	include("functions/widget-twitter.php");
	include("functions/widget-Flickr.php");
	include("functions/widget-video.php");
	include("functions/custom-post.php");
	include("functions/custom-portfolio.php");
	include("functions/custom-page.php");
	include("functions/shortcodes.php");
	include("functions/contact.php");
	
	
	function menu($page_number){
			   echo	'<ul  class="menu menu-inside">';
            $page_args = array('sort_order' => 'ASC', 'sort_column' => 'menu_order');
            $pages = get_pages($page_args); 
            $menu_items=1;
            foreach ($pages as $single_page) {
            		$trenutni="";
						if ($page_number == $menu_items) { $trenutni="class='current'";}	
            		//if(($menu_items==1)&&(!is_single())){ $trenutni=" current";}
            		
            		$pageTemplate= get_post_meta($single_page->ID , 'page_template' , true);
            		if((($pageTemplate=='Blog')&&(is_single()))||(($pageTemplate=='Blog')&&(is_search()))||(($pageTemplate=='Blog')&&(is_archive())))
            		{ 
            			$trenutni="class='current'";
            		}	 
            		
            	   $pageInMenu= get_post_meta($single_page->ID, 'show_page_in_menu' , true);
            	   $url_tab = "#"; 
            	   if (!is_front_page()){
            	   	 $url_tab = get_option("siteurl")."#";
            	   }
            	   $menu_items++;
            		if ($pageInMenu == 'Yes') {
                  	echo '<li '.$trenutni.'><a class="boxes" href="' . $url_tab . $single_page->post_name . '">' . $single_page->post_title . '</a></li> ';
                  }
            }   
				echo 	'</ul>';
	}
	
	function topHeaderDisplay()
	{
		echo '<div id="top-header">';
			echo '<div id="logo2">';
						if ( function_exists( 'get_option_tree' ) ) {
							$logo = get_option_tree( 'logo' );
						}
						if ( $logo ) { 							
							echo '<a href="'.home_url().'" title="Go Home"><img src="'. get_option_tree( 'logo' ) .'" /></a>';
						} 									
				 
			echo '</div>';
      	$socials2='';
			if ( function_exists( 'get_option_tree' ) ) {
    		    	if (get_option_tree( 'social_icons')) {
    		    				$socials2= get_option_tree( 'social_icons', $option_tree, false, true, -1 );
    		    				$img_num = 1;
    		    				if(!empty($socials2)){ 
    		    				echo '<div class="all-socials">';
								echo '<ul class="tt-wrapper2">';
								
							
								foreach( $socials2 as $social ) {
									echo '<li><a href="'.$social['link'].'" target="_blank" title="'.$social['title'].'" style="background: transparent url('.$social['image'].') no-repeat top left;"><span>'.$social['title'].'</span></a></li>';
								}
								echo '</ul></div>';
					} } }
		echo '</div>';		
	}
	
	
        function get_image_path($image) {
            global $blog_id;
            if (isset($blog_id) && $blog_id > 0) {
                $wpcontentPos = strpos($image, '/wp-content/');
                if($wpcontentPos) {
                    $image = substr($image, $wpcontentPos);
                }
            }
            return $image;
        }
	
	
/* start for comments */
if ( ! function_exists( 'inmotion_comment' ) ) :
function inmotion_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'twentyeleven' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( 'Edit', 'twentyeleven' ), '<span class="edit-link">', '</span>' ); ?></p>
	<?php
			break;
		default :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<article id="comment-<?php comment_ID(); ?>" class="comment">
			<footer class="comment-meta">
				<div class="comment-author vcard">
					<?php
						$avatar_size = 39;
						if ( '0' != $comment->comment_parent )
							$avatar_size = 39;

						echo get_avatar( $comment, $avatar_size );

						/* translators: 1: comment author, 2: date and time */
						printf( '%1$s <span class="date-and-time">%2$s</span>',
							sprintf( '<span class="fn">%s</span>', get_comment_author_link() ),
							sprintf( '<a href="%1$s"><time pubdate datetime="%2$s">%3$s</time></a>',
								esc_url( get_comment_link( $comment->comment_ID ) ),
								get_comment_time( 'c' ),
								/* translators: 1: date, 2: time */
								sprintf( '%1$s at %2$s', get_comment_date(), get_comment_time() )
							)
						);
					?>

					<?php edit_comment_link( __( 'Edit', 'pego_tr' ), '<span class="edit-link">', '</span>' ); ?>
				</div><!-- .comment-author .vcard -->

				<?php if ( $comment->comment_approved == '0' ) : ?>
					<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'pego_tr' ); ?></em>
					<br />
				<?php endif; ?>

			</footer>

			<div class="comment-content"><?php comment_text(); ?></div>

			<div class="reply">
				<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'Reply', 'pego_tr' ), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div><!-- .reply -->
		</article><!-- #comment-## -->

	<?php
			break;
	endswitch;
}
endif; // ends check for inmotion_comment()
	
/* end for comments */
	
?>
