﻿<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
    <head>
        <meta charset="iso-8859-1">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1, charset=iso-8859-1">
        <title></title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width">

        <!-- Place favicon.ico and apple-touch-icon.png in the root directory -->

        <link rel="stylesheet" href="css/normalize.css">
        <link rel="stylesheet" href="css/bootstrap.css">
		<link rel="stylesheet" href="css/resetButton.css">
        <link rel="stylesheet" href="css/style.css">
        <!--<script src="js/vendor/modernizr-2.6.2.min.js"></script>-->
    </head>
    <body>
        <!--[if lt IE 7]>
            <p class="chromeframe">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> or <a href="http://www.google.com/chromeframe/?redirect=true">activate Google Chrome Frame</a> to improve your experience.</p>
        <![endif]-->
		<input type="text" id="champsRecherche" name="nom" value="<?php  if(isset($_GET["mot"])){ echo($_GET["mot"]);}?>" size="35">
		<div id="filters">
			<input type="radio" id="option1" name="filtres" data-filter="*" checked>
			<label for="option1">Tous</label>
			<input type="radio" id="option2" name="filtres" data-filter=".intervenant"> 
			<label for="option2">Intervenants</label>
			<input type="radio" id="option3" name="filtres" data-filter=".discipline"> 
			<label for="option3">Disciplines</label>
			<!--<input type="radio" id="option4" name="filtres" data-filter=".thematique"> 
			<label for="option4">Th&eacutematiques</label>-->
		</div>
		
		<div id="menuExtraContent">
			<button href="#project" data-toggle="modal" role="button" class="titrage">Le projet</button> /
			<button href="#modeEmploi" data-toggle="modal" role="button" class="titrage">Mode d'emploi</button> /
			<button href="#credits" data-toggle="modal" role="button" class="titrage">Crédits</button> /
			<a href="http://enmi-conf.org/wp/enmi12" class="titrage linkAsButton">ENMI12</a> /
			<button href="#changelogs" data-toggle="modal" role="button" class="titrage">Changelog</button>
		</div>
		
		<div id="project" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		  <div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
			<h3 id="myModalLabel">Le Projet</h3>
		  </div>
		  <div class="modal-body">
			<p>Le glossaire des ENMI12 a pour vocation de fournir un éclairage sur les terminologies à travers trois axes : disciplinaire selon les répertoires de disciplines, thématique en fonction des sessions, intervenants selon les propos par intervenants. Parallèlement à cet aspect réferentiel, le glossaire est contributif dans la mesure où il permet au usager de commenter les définitions.</p>
		  </div>
		</div>
		
		<div id="modeEmploi" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		  <div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
			<h3 id="myModalLabel">Mode d'emploi</h3>
		  </div>
		  <div class="modal-body">
			<p>Le glossaire  des ENMI12 est un outil de recherches fonctionnant par les différentes entrées suivantes: Ars industrialis, vulgarisation, discipline et intervenants; afin de donner un ensemble varié de la définition recherchée. Il suffit d’utiliser la barre de recherche et de cliquer sur le cadre pour visualiser une définition. Il est aussi possible de laisser un commentaire dans l’onglet au même nom, ou de partager le lien de la définition avec l’URL dans le bloc entrée, sous la définition.</p>
		  </div>
		</div>
		
		<div id="credits" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		  <div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
			<h3 id="myModalLabel">Crédits</h3>
		  </div>
		  <div class="modal-body">
			<p>Ce glossaire a été conçut et réalisé par  <a href="https://twitter.com/AntremontMaxime">Maxime Antremont</a>, <a href="https://twitter.com/lapinsoig">Agathe Capin</a>, <a href="https://twitter.com/HlneCasado">Hélène Casado</a>, <a href="https://twitter.com/pitipoy2">Arthur Morlé</a>, <a href="https://twitter.com/RoriXIX">Lorry Packo</a> et <a href="https://twitter.com/Titatoa">Inès Abbadi</a> dans le cadre des Entretiens du Nouveau Monde Industriel 2012. Dirigé et initié par les étudiants du BTS Communication et Médias numériques de Boulogne-Billancourt. Avec l’encadrement de Sylvia Fredriksson, Gayané Adourian et Nicolas Loubet (<a href="http://www.knowtex.com/">Knowtex</a>), Nicolas Sauret (<a href="http://www.iri.centrepompidou.fr/">IRI</a>).</p>
		  </div>
		</div>
		
		<div id="changelogs" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		  <div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
			<h3 id="myModalLabel">Changelog</h3>
		  </div>
		  <div class="modal-body">
			<p><h3>Changements à venir (26/12)</h3>
				<ul>
					<li><p><h4>Optimisation de la vitesse d'affichage :</h4>Chargement dynamique des définitions par "blocs" dans la vue utilisateur.</p></li>
					<li><h4>Compatibilité mobiles et tablettes</h4></li>
					<li><h4>Ajout de la première couche participative (commentaires)</h4></li>
					<li><h4>Ajout de couches participatives profondes (ajout de définitions, curation/modification)</h4></li>
				</ul>
			</p>
			<p><h3>Subversions</h3>
				<ul>
					<li><h4>V1.3.a - 26/12/2012</h4>Changement mineur : ajout du changelog.</li>
					<li><h4>V1.2 - 16/12/2012</h4>Ajout du champs de recherche. <span class="ital">WIP : Commentaires / Chargements dynamiques.</span></li>
					<li><h4>V1 - 12/12/2012</h4>Première version "front" sans champs de recherche. La série des V1.X concerne les versions non participatives et leur optimisation.</li>
				</ul>
			</p>
		  </div>
		</div>
		
		
        <div id="container" class="">
		<?php
		
			function removeAccents($str, $charset='utf-8')
			{
				$str = htmlentities($str, ENT_NOQUOTES, $charset);
				
				$str = preg_replace('#&([A-za-z])(?:acute|cedil|circ|grave|orn|ring|slash|th|tilde|uml);#', '\1', $str);
				$str = preg_replace('#&([A-za-z]{2})(?:lig);#', '\1', $str); // pour les ligatures e.g. '&oelig;'
				$str = preg_replace('#&[^;]+;#', '', $str);
				$str = str_replace(' ','',$str);
				
				return $str;
			}

			function parsage_normal($noeud, $contenu_a_inserer='')
			{								
				 $innerMenu = '<ul class="content_commentMenu"><li class="defineTile hidden $6 active" >Définition</li><li class="commentTile hidden" >Commentaires</li></ul>';
				 $definitionContent = '<p class="definitionContent">';
				 $champCommentaire = '<form name="ajax" method="POST" action><input type="text" name="pseudo" class="pseudoInput" value="nom/pseudo"><input type="text" name="mail" class="mailInput" value="mail"><input type="text" name="twitter" class="twitterInput" value="twitter"><input type="text" name="twitter" class="twitterInput" value="twitter"><textarea name="comment" class="commentInput" value="votre commentaire">votre commentaire</textarea><input type="button" value="Envoyer" class="submitButton" onclick="submitForm(event)"></form>';
				 $commentLanding = '';
				 $commentSection = '<div class="commentSection hidden"><div class="commentContainer"></div>' . $champCommentaire . '</div>';
			
				 $balise_1 = array('glossaire' => '',
											'mot' => '<div class="definition folder element $8" data-mot="$6"><h1>$1</h1><input class="champsCopie" type="text" value="$7"><a class="copyButton">Copier</a><div class="tagSet">$5</div></div>',
											'arsIndustrialis' => '<div class="element arsIndustrialis definition" data-mot="$6"><h2>Glossaire Arsindustrialis</h2>' . $innerMenu . $definitionContent,
											'discipline' => '<div class="element definition discipline" data-mot="$6"><h2>$1</h2>'. $innerMenu . $definitionContent,
											'intervenant' => '<div class="element definition intervenant" data-mot="$6"><h2>$1</h2>'. $innerMenu . $definitionContent,
											'thematique' => '<div class="element definition thematique" data-mot="$6"><h2>$1</h2>'. $innerMenu . $definitionContent,
											'vulgarisation' => '<div class="element definition vulgarisation" data-mot="$6"><h2>Vulgarisation</h2>'. $innerMenu . $definitionContent,
											'#text' => ''); // Tableau des balises ouvrantes				 
											
				$balise_2 = array('glossaire' => '',
											'mot' => '<div class="element intervenant discipline thematique definition row-end"></div>',
											'arsIndustrialis' => '</p>' . $commentSection . '</div>',
											'discipline' => '</p>' . $commentSection . '</div>',
											'intervenant' => '</p>' . $commentSection . '</div>',
											'thematique' => '</p>' . $commentSection . '</div>','vulgarisation' => '</p>' . $commentSection . '</div>',
											'#text' => ''); // Tableau des balises ouvrantes
				 
				$attributs = array('mot' => 'name',
												'discipline' => 'name',
												'intervenant' => 'name',
												'thematique' => 'name',
												'vulgarisation' => 'name',
												); // Tableau des attributs
																			
				$nom = $noeud->nodeName; 
				
				if(!empty($contenu_a_inserer))
				{
					$contenu = $contenu_a_inserer; // Si c'est le cas, on met la variable de fonction en contenu
				}
				else
				{
					$contenu = $noeud->nodeValue; 
				}
				
				$premiere_balise = $balise_1[$nom];   
				
				if($noeud->hasAttributes()) // On remplace les attributs (sauf pour les images)
				{              	
					$un = $noeud->attributes->getNamedItem($attributs[$nom])->nodeValue; // 
					$premiere_balise = str_replace("$1", $un, $premiere_balise); // On remplace la valeur $1 par celle de l'attribut
				}
				
				if($nom == 'mot')
				{
					$decriptions = $noeud -> childNodes;
					$tags = '';
					$wordName = $noeud -> getAttribute('name');
					$wordName = strtolower($wordName);
					$wordName = removeAccents($wordName);
					$wordName = strtolower($wordName);
					$wordUrl = 'http://enmi-conf.org/enmi12/glossaire/index.php?mot=' . $wordName;
					
					foreach($decriptions as $description) 
					{
						
						if($description->hasAttributes())
						{		
							$nodeAttribute = $description->getAttribute('name');
							$nodeAttribute = strtolower($nodeAttribute);
							$nodeName = $description -> nodeName;
							$nodeClasses = '';
							$nodeClasses .= $nodeName . ' ';
							$formatedClass = removeAccents($nodeAttribute) . ' ' . $nodeName;

							$tags .= '<span class="tag ' . $formatedClass . '">' . $nodeAttribute . "</span>";
						}	
						else
						{
							$nodeName = $description -> nodeName;
							if($nodeName == 'arsIndustrialis'){
								$tags .= '<span class="tag arsIndustrialis">ArsIndustrialis</span>';
							}
							else if($nodeName == 'vulgarisation'){
								$tags .= '<span class="tag vulgarisation">Vulgarisation</span>';
							}
						}
								
								
						
						
						//else // ... s'il n'en a plus !
						//{
						//		//$accumulation .= parsage_normal($enfant); 
						//}
						
					}
					
					if(strstr($nodeClasses, 'discipline') == '')
					{
						$nodeClasses .= 'discipline ';
					}
					
					$wordName = removeAccents($wordName);
					$premiere_balise = str_replace("$7", $wordUrl, $premiere_balise);
					$premiere_balise = str_replace("$8", $nodeClasses, $premiere_balise);
					$premiere_balise = str_replace("$6", $wordName, $premiere_balise);
					$premiere_balise = str_replace("$5", $tags, $premiere_balise);
				}
				
				if($nom == 'arsIndustrialis' || $nom == 'discipline' || $nom == 'intervenant' || $nom == 'thematique'|| $nom == 'vulgarisation')
				{
					$classeMot = $noeud -> parentNode -> getAttribute('name');
					$classeMot = removeAccents($classeMot);
					$classeMot = strtolower($classeMot);
					
					$premiere_balise = str_replace("$6", $classeMot, $premiere_balise);
				}
				
				if($nom == 'image') // Cas particulier des images
						
				{
					$un = $contenu;
					$premiere_balise = str_replace("$1", $un, $premiere_balise);
					
					if($noeud->hasAttributes()) 
					
					{
							$deux = $noeud->attributes->getNamedItem('legende')->nodeValue;
					}
					else 
					{
							$deux = 'Image';
					}
			
					$premiere_balise = str_replace("$2", $deux, $premiere_balise);
					$intermediaire = $premiere_balise;
				
				}
				else 
				{
				   $intermediaire = $premiere_balise . $contenu . $balise_2[$nom]; // On assemble le tout
					if($nom == 'liste'  or $nom == 'puce')
					{
							$intermediaire = preg_replace("#<ul>(\s)*<li>#sU", "<ul><li>", $intermediaire);
							$intermediaire = preg_replace("#</li>(\s)*<li>#sU", "</li><li>", $intermediaire);
							$intermediaire = preg_replace("#</li>(\s)*</ul>#sU", "</li></ul>", $intermediaire);
					}
					
					if($nom == 'zcode')
					{
							$intermediaire = nl2br($intermediaire); 
					}
				}
				return $intermediaire; 
			}
			
			function parsage_enfant($noeud)
			{
				if(!isset($accumulation)) 
				{
						$accumulation = '';
				}
				
				$enfants_niv1 = $noeud->childNodes; 
				
				foreach($enfants_niv1 as $enfant)
				{
						if($enfant->hasChildNodes() == true)
						{
								$accumulation .= parsage_enfant($enfant); // Dans ce cas, on revient sur parsage_enfant
						}
						else // ... s'il n'en a plus !
						{
								$accumulation .= parsage_normal($enfant); 
						}
				}
				return parsage_normal($noeud, $accumulation);
			}
			
			function parsage($document)
			{
				$document_xml = new DomDocument();
				$document_xml->load($document);
				$elements = $document_xml->getElementsByTagName('glossaire');
				$resultat_html = '';
				$arbre = $elements->item(0);
		 
				$resultat_html = parsage_enfant($arbre);
		 
				return $resultat_html;
			}
			
			echo parsage('mots.xml');
		
    
		?>
		
        

        <script src="js/jquery-1.7.1.min.js" charset="UTF-8"></script>
        <script src="js/jquery.isotope.min.js" charset="UTF-8"></script>
        <script src="js/jquery.infinitescroll.min.js" charset="UTF-8"></script>
        <script src="js/jquery.ba-bbq.min.js" charset="UTF-8"></script>
        <script src="js/fake-element.js" charset="UTF-8"></script>
        <script src="js/main.js" charset="UTF-8"></script>
		<script src="js/form.js" charset="UTF-8"></script>
		<script src="js/modals.js" charset="UTF-8"></script>
		<script src="js/ajax.js" charset="UTF-8"></script>
		<script type="text/javascript" src="js/jquery.zclip.js"></script>
    </body>
</html>
