<?php
/*

	Plugin Name: Video Widget
	Description: Plugin is used for playing videos.
	Author:
	Version: 1.0
	Author URI: 
 
*/

class video_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
function video_Widget() {

	$widget_options = array(
		'classname' => 'video_widget',
		'description' => 'Custom video widget.');

	$control_options = array(    //dodama svoje incializirane mere
		'width' => 200,
		'height' => 400,
		'id_base' => 'video_widget'
	);

	$this->WP_Widget( 'video_widget', 'Video Widget', $widget_options, $control_options );
	
}

	
function widget( $args, $instance ) {
	
	extract( $args );
	$title = apply_filters('widget_title', $instance['title'] );
	$embed_code = $instance['embed_code'];
	$description = $instance['description'];

	echo $before_widget;
	
	if ( $title )
	{
		echo $before_title;
		echo $title;
		echo $after_title;
	}
	?>		
		<?php echo '<figure>'.$embed_code.'<figure/>';
		
	   if($description != '') 
		{
				echo '<div class="video_description">'.$description.'</div>';
		} ?>	
	<?php
	echo $after_widget;
	
}
function form( $instance ) {  

		/* Set the default values  */
		$defaults = array(
		'title' => 'My video',
		'embed_code' => '<iframe src="http://player.vimeo.com/video/22556709?title=0&amp;byline=0&amp;portrait=0" width="170" height="96" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>',
		'description' => 'Opis videa',
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); 

	 ?>

		<label for="<?php echo $this->get_field_id( 'title' ); ?>">
		<?php _e('Title:','pego_tr'); ?>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" 
				 name="<?php echo $this->get_field_name( 'title' ); ?>" 
				 value="<?php echo $instance['title']; ?>" />
		</label>
																													

		<label for="<?php echo $this->get_field_id( 'embed_code' ); ?>">
		<?php _e('Embed code:','pego_tr'); ?>
		<textarea class="widefat" type="text" id="<?php echo $this->get_field_id( 'embed_code' ); ?>" 
				    name="<?php echo $this->get_field_name( 'embed_code' ); ?>"><?php echo $instance['embed_code']; ?></textarea>
		</label>
	
	
		<label for="<?php echo $this->get_field_id( 'description' ); ?>">
		<?php _e('Optional description:','pego_tr'); ?>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'description' ); ?>" 
				 name="<?php echo $this->get_field_name( 'description' ); ?>" 
				 value="<?php echo $instance['description']; ?>" />
		</label>
	
		
	<?php
	}
}


/*     Adding widget to widgets_init and registering video widget    */
add_action( 'widgets_init', 'video_widgets' );

function video_widgets() {
	register_widget( 'video_Widget' );
}
?>