<?php 
global $scrn;
if(isset($_POST['submit']))
{
    if( !$_POST['name'] || !$_POST['email'] || !$_POST['comment'] || $_POST['name'] == '' || $_POST['email'] == ''|| $_POST['comment'] == '')
    {
        $error = 'Please fill in all the required fields';
    }
    else 
    {
            require('../../../wp-load.php');
            $scrn = get_option('scrn');
            $name = esc_html($_POST['name']);
            $email = esc_html($_POST['email']);
            $comment = esc_html($_POST['comment']);
            $msg = esc_attr('Name: ', 'SCRN') . $name . PHP_EOL;
            $msg .= esc_attr('E-mail: ', 'SCRN') . $email . PHP_EOL;
            $msg .= esc_attr('Message: ', 'SCRN') . $comment;
            $to = $scrn['email'];
            $sitename = is_multisite() ? $current_site->site_name : get_bloginfo('name');
            $subject = '[' . $sitename . ']' . ' New Message';
            $headers = 'From: ' . $name . ' <' . $email . '>' . PHP_EOL;
            wp_mail($to, $subject, $msg, $headers);
    }
}
get_header(); ?>    
    <?php 
    if ( ( $locations = get_nav_menu_locations() ) && $locations['top-menu'] ) {
        $menu = wp_get_nav_menu_object( $locations['top-menu'] );
        $menu_items = wp_get_nav_menu_items($menu->term_id);
        $include = array();
        foreach($menu_items as $item) {
            if($item->object == 'page')
                $include[] = $item->object_id;
        }
        query_posts( array( 'post_type' => 'page', 'post__in' => $include, 'posts_per_page' => count($include), 'orderby' => 'post__in' ) );
    }
    else
    {
        if(isset($scrn['pages_topmenu']) && $scrn['pages_topmenu'] != '' )
            query_posts(array( 'post_type' => 'page', 'post__in' => $scrn['pages_topmenu'], 'posts_per_page' => count($scrn['pages_topmenu']), 'orderby' => 'menu_order', 'order' => 'ASC' ) );
        else
            query_posts(array( 'post_type' => 'page', 'posts_per_page' => 4, 'orderby' => 'menu_order', 'order' => 'ASC' ) );
    }
    $i = 1;
    while(have_posts() ) : the_post(); ?>
        <?php $temp = get_post_meta($post->ID, 'vp_settings', true);?>
        <div class="bg <?php if(isset($temp['variation']) && $temp['variation'] == 2) echo 'dark-bg';?>" id="<?php echo $post->post_name;?>"
            <?php if(isset($temp['variation']) && $temp['variation'] == 3) { echo 'style="';
            if(isset($temp['background_color']) && $temp['background_color'] != '') echo 'background-color: #' . $temp['background_color']; 
            else if(isset($temp['background']) && $temp['background'] != '') echo 'background-image: url(\'' . $temp['background'] . '\')'; echo '"'; } ?>>
            <div class="container">
                <div class="sixteen columns">
                        <h2>
                            <span class="lines">
                                <?php $top_title = get_post_meta($post->ID, 'top_title', true); 
                                if($top_title != '') echo $top_title; else the_title();?>
                            </span>
                        </h2>
                 </div> <!-- end sixteen columns -->

                 <div class="clear"></div>

            <?php global $more; $more = 0; the_content('');?>
                
            </div> <!-- end container -->
        </div> <!-- end bg -->
        <div id="separator1">
            <div class="bg<?php echo ($i+1); echo ' bg';?>" style="<?php if(isset($temp['slogan_bg']) && $temp['slogan_bg'] != '') echo 'background-image: url(\'' . $temp['slogan_bg'] . '\')';?> "></div>
            <p class="separator"><?php if(isset($temp['slogan']) && $temp['slogan'] != '') echo $temp['slogan'];?></p>
        </div>
    <?php $i++; endwhile; wp_reset_query(); ?>

    <div id="contact" class="dark-bg">
        <div class="container">
        
            <div class="sixteen columns">
                <h2 class="white"><span class="lines"><?php _e('Contact', 'SCRN');?></span></h2>
            </div> <!-- end sixteen columns -->

            <?php if(isset($scrn['contact_description']) && $scrn['contact_description'] != '') { ?>
                <div class="sixteen columns">
                    <p><?php echo esc_attr($scrn['contact_description']);?></p>
                </div> <!-- end sixteen columns -->
            <?php } ?>
            
            <div class="clear"></div>
            
            <div class="eight columns">
                <div class="contact-form">
                    
                    <div class="done">
                        <?php _e('<b>Thank you!</b> I have received your message.', 'SCRN');?> 
                    </div>
                
                    <form method="post" action="process.php">
                        <p><?php _e('name', 'SCRN');?></p>
                        <input type="text" name="name" class="text" />
                        
                        <p><?php _e('email', 'SCRN');?></p>
                        <input type="text" name="email" class="text" id="email" />

                        <p><?php _e('message', 'SCRN');?></p>
                        <textarea name="comment" class="text"></textarea>

                        <input type="submit" id="submit" value="<?php _e('send', 'SCRN');?>" class="submit-button" />
                    </form>
                        
                </div> <!-- end contact-form -->
            </div> <!-- end eight columns -->
            
            <div class="eight columns">
                
                <div class="contact-info">
                    
                    <h5><?php _e('Contact Info', 'SCRN');?></h5>
                
                    <?php if(isset($scrn['phone']) && $scrn['phone'] != '') { ?><p class="white"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-phone.png" alt="" /> <?php echo $scrn['phone'];?></p><?php } ?>
                    <?php if(isset($scrn['email']) && $scrn['email'] != '') { ?><p class="white"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-email.png" alt="" /> <a href="mailto:<?php echo $scrn['email'];?>"><?php echo encEmail($scrn['email']);?></a></p><?php } ?>
                    <?php if(isset($scrn['location']) && $scrn['location'] != '') { ?><p class="white"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-address.png" alt="" /> <?php echo $scrn['location'];?></p><?php } ?>
                </div> <!-- end contact-info -->
                
                <div class="social">
                    <ul>
                        <?php if(isset($scrn['twitter_username'])  && $scrn['twitter_username'] != '') { ?><li><a href="http://twitter.com/<?php echo $scrn['twitter_username'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-twitter2.png" alt="" /></a></li><?php } ?>
                        <?php if(isset($scrn['facebook_url'])  && $scrn['facebook_url'] != '') { ?><li><a href="<?php echo $scrn['facebook_url'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-facebook2.png" alt="" /></a></li><?php } ?>
                        <?php if(isset($scrn['gplus_url'])  && $scrn['gplus_url'] != '') { ?><li><a href="<?php echo $scrn['gplus_url'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-gplus.png" alt="" /></a></li><?php } ?>
                        <?php if(isset($scrn['linkedin_url'])  && $scrn['linkedin_url'] != '') { ?><li><a href="<?php echo $scrn['linkedin_url'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-linkedin.png" alt="" /></a></li><?php } ?>
                        <?php if(isset($scrn['forrst_url'])  && $scrn['forrst_url'] != '') { ?><li><a href="<?php echo $scrn['forrst_url'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-forrst.png" alt="" /></a></li><?php } ?>
                        <?php if(isset($scrn['skype_url'])  && $scrn['skype_url'] != '') { ?><li><a href="<?php echo $scrn['skype_url'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-skype.png" alt="" /></a></li><?php } ?>
                        <?php if(isset($scrn['dribbble_url'])  && $scrn['dribbble_url'] != '') { ?><li><a href="<?php echo $scrn['dribbble_url'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-dribbble.png" alt="" /></a></li><?php } ?>
                        <?php if(isset($scrn['pinterest_url'])  && $scrn['pinterest_url'] != '') { ?><li><a href="<?php echo $scrn['pinterest_url'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-pinterest.png" alt="" /></a></li><?php } ?>
                        <?php if(isset($scrn['vimeo_url'])  && $scrn['vimeo_url'] != '') { ?><li><a href="<?php echo $scrn['vimeo_url'];?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icn-vimeo.png" alt="" /></a></li><?php } ?>
                    </ul>
                </div> <!-- end social -->
                
            </div> <!-- end eight columns -->
            
            <div class="clear"></div>

            <div class="sixteen columns">
                <div class="copyright">
                    <p>&copy; <?php the_time("Y");?> <?php _e('All Rights Reserved', 'SCRN');?>, <?php _e('designed by ', 'SCRN');?> <a href="http://teothemes.com">TeoThemes</a></p>
                </div>
            </div>
            
            
        </div> <!-- end container -->
        
    </div> <!-- end contact -->

    
    
<?php get_footer();?>