<?php include("scripts/contact-form.php"); ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>
	<head>
		<!-- Meta Tags -->
		<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
		<meta name="viewport" content="initial-scale=1, maximum-scale=1" />
  		<meta name="viewport" content="width=device-width" />
		<title><?php wp_title('|', true, 'right'); ?><?php bloginfo('name'); ?></title>

		<!-- Stylesheets -->
		<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/style.css" type="text/css" media="screen" />
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/reset.css" type="text/css" media="screen" />
		<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/fancybox/jquery.fancybox-1.3.4.css" media="screen" />
		<!--[if lt IE 9]>
			<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/ie8-and-down.css" />
		<![endif]-->
		<!--[if lte IE 8]>
		  <link rel="stylesheet" type="text/css" media="screen" href="<?php echo get_template_directory_uri(); ?>/css/ie8.css" />
		<![endif]-->		
		
		<!-- Fonts -->
		<link href='http://fonts.googleapis.com/css?family=Droid+Sans' rel='stylesheet' type='text/css' />		
		<!-- Favicon -->
		<?php
		$favicon =  get_template_directory_uri().'/favicon.ico';
		if ( function_exists( 'get_option_tree' ) ) {
    		    if (get_option_tree( 'favicon')) {
    		    	$favicon = get_option_tree( 'favicon' );
				}
			}
		?>
		<link rel="icon" href="<?php echo $favicon; ?>" type="image/x-ico" />
		<!-- Check for option tree -->
		<?php
  			if ( !function_exists( 'get_option_tree') ) {
				echo '<h1 style="color:white; background-color:#494a4a;">You need the Option Tree plugin installed for this theme!<br/>
					You can get it here: <a href="http://wordpress.org/extend/plugins/option-tree/" target="_blank" class="ot-warning">Option tree</a></h1>';
			}
		?>

		
		<!-- start for google maps -->	
		<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
		
		<?php 
			$map_latitude_value='';
			$map_longitude_value='';
			$map_pin_picture='';
			if ( function_exists( 'get_option_tree') ) {
				if( get_option_tree( 'map_latitude_value') ) {
					$map_latitude_value=get_option_tree( 'map_latitude_value');
				}
				if( get_option_tree( 'map_longitude_value') ) {
					$map_longitude_value=get_option_tree( 'map_longitude_value');
				}
				if( get_option_tree( 'map_pin_picture') ) {
					$map_pin_picture=get_option_tree( 'map_pin_picture');
				}		 	
			}			
		?>			
		<!-- end for google maps -->		
		
		<!-- main template color -->
		<?php 
			$main_template_color = "#91a4ac";
			if ( function_exists( 'get_option_tree' ) ) {
    		    if (get_option_tree( 'main_template_color')) {
    		    	$main_template_color = get_option_tree( 'main_template_color' );
				}
			}
			$css_output='<style type="text/css">';
			$css_output.=' .hl-main, .button a, .circle-p1, #eden a.ajax-back, #eden .client-stuff p, #eden .url-stuff a, .post-title, input#submit, #sidebar-right input#searchsubmit, #main-menu a, a.readmore, .quote, #contact-form #submit-button  {background-color: '.$main_template_color.'; }';
			$css_output.=' a, #portfolio-filter ul li a:hover, #portfolio-filter li.active a, #eden .item-desc p, p.contact-paragraph-call span, .list-1 li a:hover,  p.blog-post-date,  .blog-details ul li a, .blog-post-tags a, #respond h3,  .reply a, #respond a, h3#comments, ol.commentlist li div.comment-meta a,   #sidebar-right .widget ul li a:hover, h4.widget-title, #foot-col1 a, #foot-col2 a, #foot-col3 a, #foot-col4 a,  #foot-col1 a, #foot-col2 a, #foot-col3 a, #foot-col4 a,  #foot-col1 a:hover, #foot-col2 a:hover, #foot-col3 a:hover, #foot-col4 a:hover, .menu-inside a:hover, .menu-inside .current a  {color: '.$main_template_color.'; }';
			$css_output.='  .post-date, .news-date {background: '.$main_template_color.'; }';
			$css_output.=' #headerSlideContainer {border-top: 3px solid '.$main_template_color.';}'; 
			
			$css_output.=' .dotted-line { border-bottom: 2px dashed '.$main_template_color.';}'; 			
			$css_output.=' .blog-post-tags a:hover {border-bottom: 1px dashed '.$main_template_color.';}'; 	
			$css_output.=' #header {	border-bottom: 4px solid '.$main_template_color.';}';
			$css_output.=' .page-title {	background: '.$main_template_color.' url('. get_template_directory_uri() .'/images/bg-title.png) repeat;}';
			$css_output.=' ::selection {background: '.$main_template_color.'; }';
			$css_output.=' ::-moz-selection {background: '.$main_template_color.'; }';
			if ( function_exists( 'get_option_tree') ) {	
				if (get_option_tree( 'heading_h1_size')) {
					$css_output.=' h1 { font-size: '.get_option_tree( 'heading_h1_size').'px; }';				
				}
				if (get_option_tree( 'heading_h2_size')) {
					$css_output.=' h2 { font-size: '.get_option_tree( 'heading_h2_size').'px; }';				
				}
				if (get_option_tree( 'heading_h3_size')) {
					$css_output.=' h3 { font-size: '.get_option_tree( 'heading_h3_size').'px; }';				
				}
				if (get_option_tree( 'heading_h4_size')) {
					$css_output.=' h4 { font-size: '.get_option_tree( 'heading_h4_size').'px; }';				
				}
			}
			$css_output.='</style>';
			echo $css_output;
   
		?>
		<!--  code for google analytics -->
		<?php 
		$googleAnalitics = '';
		if ( function_exists( 'get_option_tree') ) {
				$googleAnalitics = get_option_tree( 'google_analytics');
				echo $googleAnalitics;
		}
		?>	
<script type="text/javascript">
			(function() {
				window.onload = function(){
				
				var pinkParksStyles = '';
				
				if (jQuery.browser.msie  && parseInt(jQuery.browser.version, 10) === 8) {
				
				} else {
					var pinkParksStyles = [ { stylers: [ { invert_lightness: false }, { hue: "#ff0000" }, { saturation: -92 }, { lightness: 5 } ] },{ featureType: "poi", elementType: "labels", stylers: [ { visibility: "off" } ] },{ featureType: "road", elementType: "labels", stylers: [ { visibility: "on" }, { lightness: 20 } ] },{ featureType: "landscape", stylers: [ { visibility: "off" } ] },{ featureType: "transit.station", elementType: "labels", stylers: [ { lightness: 100 } ] },{ featureType: "road.arterial", stylers: [ { visibility: "on" } ] },{ } ];
				}

					
				var pinkMapType = new google.maps.StyledMapType(pinkParksStyles,
					{name: "Our Location"});
				var mapOptions = {
					zoom: 11,
					center: new google.maps.LatLng(<?php echo $map_latitude_value; ?>, <?php echo $map_longitude_value; ?>),
					mapTypeControlOptions: {
					mapTypeIds: [google.maps.MapTypeId.ROADMAP, 'pink_parks']
					}
				};
				var map = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);
				  map.mapTypes.set('pink_parks', pinkMapType);
				  map.setMapTypeId('pink_parks');
  
				var image = "<?php echo $map_pin_picture; ?>";

				var marker = new google.maps.Marker({
					position: new google.maps.LatLng(<?php echo $map_latitude_value ?>, <?php echo $map_longitude_value ?>),
					map: map,
					icon: image
				}); 
				}
			})();
		</script>

		<?php wp_enqueue_script('jquery'); ?>
		<?php wp_head(); ?>
	</head>
 <?php
	//default background start
	$default_body_data='';
	$default_fix_image=0;
	$default_background_image='';
	$default_background_repeat='';
	if ( function_exists( 'get_option_tree') ){
			if( get_option_tree( 'default_background_color') ) {
				$default_background_color=get_option_tree( 'default_background_color');
					if (!empty($default_background_color)){
							$default_body_data.=' '.$default_background_color;							
					}
			}
			if( get_option_tree( 'default_background_image')) {
				$default_background_image=get_option_tree( 'default_background_image');
				$default_background_repeat=get_option_tree( 'default_background_repeat');
				switch ($default_background_repeat ) {
				    case 'No repeat':
				        $default_background_repeat='no-repeat';
				        $default_fix_image++;
				        break;
				    case 'Repeat':
				        $default_background_repeat='repeat';
				        break;
				    case 'Repeat x':
				        $default_background_repeat='repeat-x';
				        break;
				    case 'Repeat y':
				        $default_background_repeat='repeat-y';
				        break;
				    default:
				    	  $default_background_repeat='no-repeat';
				        break;
				}
				
				if (!empty($default_background_image)){
							$default_body_data.=' url('.$default_background_image.') top center '.$default_background_repeat.'';
							$default_fix_image++;
							$picture=$default_background_image;
					}
			}
   
			
			if (!empty($default_body_data)){
					$default_body_data=' style="background:'.$default_body_data.'; background-attachment:fixed;" ';
			}
			else {
					$default_body_data='';	
			}
	}  
	//default background end
	?>
	<body <?php body_class(); ?><?php echo $default_body_data;  ?> >
		

	<div id="all-wrapper">
	
	
	
		<div id="left-sidebar"><!-- start left-sidebar -->
			<div id="logo" class="fl"><!-- start logo -->
				<?php 
				global $option_tree;
				if ( function_exists( 'get_option_tree') ) {
					$option_tree = get_option('option_tree');
				}
				
						$logo='';
						if ( function_exists( 'get_option_tree' ) ) {
							$logo = get_option_tree( 'logo' );
						}
						if ( $logo != '' ) { ?>								
							<a href="<?php echo get_option('siteurl'); ?>" title="Go Home"><img src="<?php echo get_option_tree( 'logo' ) ?>" alt="logo" /></a>
						<?php } 							
					?>  
			</div><!-- end logo -->
		
			 <!-- koda za menu -->
			<ul class="menu" id="main-menu">
				<?php
            $page_args = array('sort_order' => 'ASC', 'sort_column' => 'menu_order');
            $pages = get_pages($page_args); 
            $menu_items=1;
            foreach ($pages as $single_page) {
            		$trenutni="";
            		//if(($menu_items==1)&&(!is_single())){ $trenutni=" current";}
            		
            		$pageTemplate= get_post_meta($single_page->ID , 'page_template' , true);
            		if(($pageTemplate=='Blog')&&(is_single())){ $trenutni="class='current'";}	 
            		
            	   $pageInMenu= get_post_meta($single_page->ID, 'show_page_in_menu' , true);
				  
            	   $url_tab = "#"; 
            	   if (!is_front_page()){
            	   	 $url_tab = get_option("siteurl")."#";
            	   }
            	   $menu_items++;
            		if ($pageInMenu == 'Yes') {						
							echo '<li '.$trenutni.'><a class="boxes" href="' . $url_tab . $single_page->post_name . '">' . $single_page->post_title . '</a></li> ';						
                  }                 
            }
            ?>  
			</ul>						
			<!-- start social icons -->
			<?php
			$socials='';
			if ( function_exists( 'get_option_tree' ) ) {
    		    		  if (get_option_tree( 'social_icons')) {
    		    				$socials= get_option_tree( 'social_icons', $option_tree, false, true, -1 );
    		    				$img_num = 1;
    		    				if(!empty($socials)){ ?>
								<ul class="tt-wrapper">								
								<?php
								foreach( $socials as $social ) {
									echo '<li><a href="'.$social['link'].'" target="_blank" title="'.$social['title'].'" style="background: transparent url('.$social['image'].') no-repeat top left;"><span>'.$social['title'].'</span></a></li>';
								}
								echo '</ul>';
					} } }					
			?>	
		
		</div><!-- end left-sidebar -->
		
		<div id="container"><!-- start container -->				