DRAW_MODE_RECT = 1;
DRAW_MODE_POLY = 2;
DRAW_MODE_FREE = 3;
DRAW_MODE_EDIT = 4;

paper.install(window);

var draw_mode,
    currentpath,
    raster,
    group,
    ghostRaster,
    polygonClosed,
    polygonClosingTimeout,
    clipPolygon,
    isSelecting,
    dragMode,
    segmentIndex,
    imageRatio,
    placeHolder;

$(function() {
    
    var hitOptions = {
        segments: true,
        stroke: true,
        fill: true,
        tolerance: 5
    };
    
    tool = new Tool();
    
    function setDrawMode(mode) {
        draw_mode = mode;
        $(".modeselector li").each(function() {
            if (+$(this).attr("drawmode") == mode) {
                $(this).addClass("selected");
            } else {
                $(this).removeClass("selected");
            }
        })
        if (draw_mode != DRAW_MODE_EDIT) {
            polygonClosed = true;
            initDraw();
        }
    }
    
    function delPath() {
        if (typeof currentpath !== "undefined") {
            currentpath.remove();
            currentpath = undefined;
        }
        if (typeof clipPolygon !== "undefined") {
            clipPolygon.remove();
            clipPolygon = undefined;
        }
    }
    
    function startPath() {
        currentpath = new Path();
        currentpath.strokeWidth = 3;
        currentpath.strokeColor = '#ff0000';
        clipPolygon = new Path();
        ghostRaster.opacity = .7;
        if (typeof group !== "undefined") {
            group.remove();
        }
        group = new Group(clipPolygon, raster);
        group.clipped = true;
    }
    
    function finishEdit() {
        polygonClosed = true;
        currentpath.strokeColor = '#ff0000';
        currentpath.strokeWidth = 1;
        currentpath.fillColor = '#000000';
        currentpath.closed = true;
        ghostRaster.opacity = .3;
        setDrawMode(DRAW_MODE_EDIT);
    }
    
    function initDraw() {
        delPath();
        if (typeof ghostRaster !== "undefined") {
            ghostRaster.opacity = 1;
        }
        view.draw();
    }
    
    function setPolygonTimeout() {
        window.clearTimeout(polygonClosingTimeout);
        polygonClosingTimeout = setTimeout(function() {
            switch (draw_mode) {
                case DRAW_MODE_FREE:
                    currentpath.simplify();
                    currentpath.flatten(10);
                    clipPolygon.remove();
                    group.remove();
                    clipPolygon = currentpath.clone();
                    group = new Group(clipPolygon, raster);
                    group.clipped = true;
                break;
            }
            finishEdit();
            view.draw();
        }, 3000);
    }
    
    function calcPreview() {
        if (typeof currentpath !== "undefined") {
            var _b = currentpath.bounds,
                _w = _b.width + 20,
                _h = _b.height + 20,
                _data = view.canvas.getContext('2d').getImageData(_b.x - 10, _b.y - 10, _w , _h ),
                _c = document.createElement('canvas');
            _c.width = Math.floor(Math.max(160,_w,_h*4/3));
            _c.height = Math.floor(Math.max(120,_h,_w*3/4));
            _c.getContext('2d').putImageData(_data, Math.floor((_c.width - _w) / 2), Math.floor((_c.height - _h) / 2));
            $("#preview").attr("src", _c.toDataURL());
        } else {
            $("#preview").attr("src", "placeholder.png");
        }
    }
    
    tool.onMouseDown = function(event) {
        switch (draw_mode) {
            case DRAW_MODE_FREE:
            case DRAW_MODE_POLY:
                if (polygonClosed) {
                    delPath();
                    startPath();
                    polygonClosed = false;
                }
                if (currentpath.segments.length == 0) {
                    currentpath.add(event.point);
                    clipPolygon.add(event.point);
                }
                currentpath.add(event.point);
                clipPolygon.add(event.point);
                setPolygonTimeout();
            break;
            case DRAW_MODE_RECT:
                delPath();
                startPath();
                for (var _i = 0; _i < 4; _i++) {
                    currentpath.add(event.point);
                    clipPolygon.add(event.point);
                }
                currentpath.closed = true;
                clipPolygon.closed = true;
            break;
            case DRAW_MODE_EDIT:
                var hitResult = project.hitTest(event.point, hitOptions);
                if (hitResult && hitResult.item) {
                    dragMode = hitResult.type;
                } else {
                    dragMode = undefined;
                }
                switch(dragMode) {
                    case "segment":
                        segmentIndex = hitResult.segment.index;
                    break;
                    case "stroke":
                        segmentIndex = hitResult.location.index + 1;
                        currentpath.insert(segmentIndex, event.point);
                        clipPolygon.insert(segmentIndex, event.point);
                    break;
                }
            break;
        }
    }
    
    tool.onMouseMove = function(event) {
        switch (draw_mode) {
            case DRAW_MODE_EDIT:
                var hitResult = project.hitTest(event.point, hitOptions);
                if (hitResult && hitResult.item) {
                    currentpath.strokeColor = '#0080ff';
                    currentpath.selected = true;
                    document.body.style.cursor = "pointer";
                } else {
                    currentpath.strokeColor = '#ff0000';
                    currentpath.selected = false;
                    document.body.style.cursor = "";
                }
            break;
        }
        
    }
    
    tool.onMouseDrag = function(event) {
        switch (draw_mode) {
            case DRAW_MODE_POLY:
                currentpath.lastSegment.point = event.point;
                clipPolygon.lastSegment.point = event.point;
                setPolygonTimeout();
            break;
            case DRAW_MODE_FREE:
                currentpath.add(event.point);
                clipPolygon.add(event.point);
                setPolygonTimeout();
            break;
            case DRAW_MODE_RECT:
                clipPolygon.segments[1].point.x = clipPolygon.segments[2].point.x = currentpath.segments[1].point.x = currentpath.segments[2].point.x = event.point.x;
                clipPolygon.segments[3].point.y = clipPolygon.segments[2].point.y = currentpath.segments[3].point.y = currentpath.segments[2].point.y = event.point.y;
            break;
            case DRAW_MODE_EDIT:
                switch (dragMode) {
                    case "fill":
                        currentpath.translate(event.delta);
                        clipPolygon.translate(event.delta);
                    break;
                    case "segment":
                    case "stroke":
                        currentpath.segments[segmentIndex].point = event.point;
                        clipPolygon.segments[segmentIndex].point = event.point;
                    break;
                }
            break;
        }
    }
    
    
    tool.onMouseUp = function(event) {
        switch (draw_mode) {
            case DRAW_MODE_RECT:
                finishEdit();
            break;
        }
    }
    
    var canvas = document.getElementById('playground');
    paper.setup(canvas);
    
    $(".modeselector li").click(function() {
        setDrawMode(+$(this).attr("drawmode"));
    })
    
    var img = new Image();
    
    setDrawMode(DRAW_MODE_RECT);
    
    img.onload = function() {
        imageRatio = Math.min(1, view.bounds.width / img.width, view.bounds.height / img.height);
        ghostRaster = new Raster(this);
        ghostRaster.scale(imageRatio);
        ghostRaster.position = new Point(ghostRaster.bounds.width / 2, ghostRaster.bounds.height / 2);
        raster = ghostRaster.clone();
        initDraw();
    }
//    img.src ="http://www.photo.rmn.fr/LowRes2/TR1/Q83I0G/03-015341.jpg"
    img.src = "04-500790.jpg";
    
    window.setInterval(calcPreview,500);
        
});