$(function(){
//filters
	$('.filters a').each(function(){
		var text = $.trim($(this).text());
		if(text.length > 30){
			$(this).text(text.substr(0, 30) + '...')
		}
	});
//masonry
	var masonry465 = $('.masonry-465');
	masonry465.masonry({
	  columnWidth: 465,
	  itemSelector: '.item-masonry',
	  gutter : 20
	});

	var masonry225 = $('.masonry-225');
	masonry225.masonry({
	  columnWidth: 225,
	  itemSelector: '.item-masonry',
	  gutter : 16
	});

//popin
	$('.open-popin').bind('click', function(e){
		e.preventDefault();
		var target = $(this).attr('href');
		$('.popin-wrap').fadeIn(function(){
			$(target).show();
		});
	});

	$('.close-popin, .popin-wrap').bind('click', function(e){
		e.preventDefault();
		e.stopPropagation();
		$('.popin-wrap').fadeOut(function(){
			$('.popin').hide();
		});
	});

	$('.popin').bind('click', function(e){
		e.stopPropagation();
	});
//tag it
	if($('.tag-it').length){
		var keywordsTagIt = $('.tag-it').tagit({
			allowSpaces : true
		});
		$('.list-key-add a').bind('click', function(e){
			e.preventDefault();
			var tag = $(this).attr('data-tag');
			keywordsTagIt.tagit("createTag", tag);
		});
	}
//map
	if($('#map').length){
		initmap()
	}
function initmap() {
	// set up the map
	map = new L.Map('map');

	// create the tile layer with correct attribution
	var osmUrl='http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png';
	var osm = new L.TileLayer(osmUrl, {minZoom: 3, maxZoom: 20});		

	// start the map in South-East England
	map.setView(new L.LatLng(48.833, 2.333),4);
	map.addLayer(osm);

	// markers
	var marker1 = L.marker([48.833, 2.333]).addTo(map);
	marker1.bindPopup("Beaux-Arts de Paris");
	var marker2 = L.marker([47.233,-1.583]).addTo(map);
	marker2.bindPopup("Beaux-Arts de Nantes");
}

});//ready
