# -*- coding: utf-8 -*-
'''
Created on Feb 12, 2013

@author: ymh
'''

from egonomy.models import Fragment
from django.db import models
from haystack import signals

class EgonomySignalProcessor(signals.BaseSignalProcessor):
    def setup(self):
        # Listen only to the ``User`` model.
        models.signals.post_save.connect(self.handle_save, sender=Fragment)
        models.signals.post_delete.connect(self.handle_delete, sender=Fragment)

    def teardown(self):
        # Disconnect only for the ``User`` model.
        models.signals.post_save.disconnect(self.handle_save, sender=Fragment)
        models.signals.post_delete.disconnect(self.handle_delete, sender=Fragment)
