# -*- coding: utf-8 -*-
'''
Created on Feb 12, 2013

@author: ymh
'''

from haystack import indexes
from egonomy.models import ImageMetadata
from egonomy.models import Fragment


class ImageMetadataIndex(indexes.SearchIndex, indexes.Indexable):
    
    text = indexes.CharField(document=True, use_template=True)
    
    title = indexes.CharField(model_attr='titre', null=True)
    description = indexes.CharField(model_attr='description', null=True)
    photograph = indexes.CharField(model_attr='photographe', null=True)
    author = indexes.CharField(model_attr='auteur', null=True)
    period = indexes.CharField(model_attr='periode', null=True)
    technic = indexes.CharField(model_attr='technique', null=True)
    site = indexes.CharField(model_attr='site', null=True)
    location = indexes.CharField(model_attr='lieu', null=True)
    localization = indexes.CharField(model_attr='localisation', null=True)
    tags = indexes.CharField(model_attr='mots_cles', null=True)
    
    def get_model(self):
        return ImageMetadata


class FragmentIndex(indexes.SearchIndex, indexes.Indexable):
    
    text = indexes.CharField(document=True, use_template=True)
    
    image = indexes.CharField(model_attr='image', indexed=False, stored=True)
    author = indexes.CharField(model_attr='author', null=True, stored=True)
    title = indexes.CharField(model_attr='title', null=True, stored=True)
    description = indexes.CharField(model_attr='description', null=True, stored=True)
    tags = indexes.CharField(model_attr='tags', null=True, stored=True)
    
    def get_model(self):
        return Fragment
