$(function() {
    
    $('.masonry-177').masonry({
        columnWidth: 177,
        itemSelector: '.item-masonry'
    });
    
    function updateMasonry() {
        $('.masonry-177').masonry('layout');
    }
    
    var keywordsobj = {};
    
    $(".item-masonry").each(function(i, element) {
        $(element)
            .attr("data-keywords")
            .split(",")
            .forEach(function(kw) {
                var keyword = kw.replace(/(^\s+|\s+$)/g,''),
                    basekw = keyword.toLowerCase();
                if (!keywordsobj.hasOwnProperty(basekw)) {
                    keywordsobj[basekw] = {
                        keyword: keyword,
                        basekeyword: basekw,
                        count: 0,
                        items: $(),
                        enabled: true
                    };
                }
                kwobj = keywordsobj[basekw];
                kwobj.count++;
                kwobj.items.push(element);
            });
    });
    
    var keywordslist = [];
    
    for (var k in keywordsobj) {
        if (keywordsobj.hasOwnProperty(k)) {
            keywordslist.push(keywordsobj[k]);
        }
    }
    
    keywordslist.sort(function(a, b) {
        return b.count - a.count;
    });
    
    var filterlist = $(".filters");
    
    function updateKeywords() {
        var enabledItems = $();
        keywordslist.forEach(function(kw) {
            if (kw.enabled) {
                enabledItems = enabledItems.add(kw.items);
                kw.li.removeClass("disabled");
            } else {
                kw.li.addClass("disabled");
            }
        });
        $(".item-masonry").addClass("disabled");
        enabledItems.removeClass("disabled");
    }
    
    keywordslist.slice(0,100).forEach(function(kw) {
        var li = $('<li class="box-shadow-2">'),
            texta = $('<a class="display-keyword" href="#">'),
            actiona = $('<a class="icon-action" href="#">');
        texta.text(kw.keyword + ' ');
        li.append(actiona);
        li.append(texta);
        kw.li = li;
        li.click(function() {
            if (kw.enabled) {
                keywordslist.forEach(function(k) {
                    k.enabled = false;
                });
                kw.enabled = true;
            } else {
                keywordslist.forEach(function(k) {
                    k.enabled = true;
                });
            }
            updateKeywords();
            return false;
        });
        actiona.click(function() {
            kw.enabled = !kw.enabled;
            updateKeywords();
            return false;
        });
        filterlist.append(li);
    })
        
    $('.toggle-comment').click(function(e){
        e.preventDefault();
        $('.show-comment, .hide-comment').hide();
        if($('.mosaic').length){
            $('.mosaic').removeClass('mosaic').addClass('mosaic-comment');
            $('.hide-comment').show();
        }else{
            $('.mosaic-comment').removeClass('mosaic-comment').addClass('mosaic');
            $('.show-comment').show();
        }
        updateMasonry();
    });
    
});
