from django.conf import settings
from django.contrib.auth.decorators import login_required
#from django.contrib.auth.models import Group, User
from django.core.files.storage import FileSystemStorage
#from django.core.paginator import Paginator, InvalidPage, EmptyPage
from django.shortcuts import get_object_or_404, render_to_response, redirect
from django.template import RequestContext
from sorl.thumbnail.images import ImageFile
from models import Image, Fragment
from random import randint



def home(request):
    
    # if the request has a "search" get parameter, we search this term
    search = None
    nb_results = 1
    if "search" in request.GET:
        search = request.GET["search"]
        field = "all"
        if "field" in request.GET:
            field = request.GET["field"]
        
    #i =  randint(0, 200000)
    #img_list = Image.objects.all()[i:i+12]
    img_list = Image.objects.all()[:12]
    
    frg_list = Fragment.objects.all()[:12]
    
    return render_to_response("egonomy_home.html",
                              {'img_list':img_list, 'fragment_list':frg_list, "search":search, "nb_results":nb_results},
                              context_instance=RequestContext(request))


def annotate_picture(request, image_id):

    img = get_object_or_404(Image, id=image_id) 
    
    frg1 = {"image": img, "path":"M 0 .5 L .5 0 L 1 .5 L .5 1 Z", "title":"Fragment X", "author":"juju"}
    frg2 = {"image": img, "path":"M .1 .3 L .5 .1 L .8 .7 Z", "title":"Fragment Y", "author":"loulou"}
    frg3 = {"image": img, "path":"M 0 .5 L .5 0 L 1 .5 L .5 1 Z", "title":"Fragment Z", "author":"juju"}
    frg4 = {"image": img, "path":"M .2 .5 L .7 .2 L .8 .7 Z", "title":"Fragment W", "author":"loulou"}
    frg_list = [frg1,frg2,frg3,frg4,frg3,frg4,frg1,frg4,frg3,frg4,frg1,frg2]
    
    return render_to_response("egonomy_annotate_picture.html",
                              {'img': img, 'fragment_list': frg_list, 'image_id':image_id},
                              context_instance=RequestContext(request))


def view_fragment(request, fragment_pk):
    
    frg = get_object_or_404(Fragment, pk=fragment_pk)
    
    frg1 = {"image": frg.image, "path":"M 0 .5 L .5 0 L 1 .5 L .5 1 Z", "title":"Fragment X", "author":"juju", "users_keywords":"Modernite, Ready-made"}
    frg2 = {"image": frg.image, "path":"M .1 .3 L .5 .1 L .8 .7 Z", "title":"Fragment Y", "author":"loulou", "users_keywords":"Modernite, Ready-made"}
    frg3 = {"image": frg.image, "path":"M 0 .5 L .5 0 L 1 .5 L .5 1 Z", "title":"Fragment Z", "author":"juju", "users_keywords":"Modernite, Ready-made"}
    frg4 = {"image": frg.image, "path":"M .2 .5 L .7 .2 L .8 .7 Z", "title":"Fragment W", "author":"loulou", "users_keywords":"Modernite, Ready-made"}
    frg_list = [frg1,frg2,frg3,frg3,frg4,frg4,frg3,frg4,frg1,frg4,frg1]
    
    return render_to_response("egonomy_view_fragment.html",
                              {'fragment': frg, 'fragment_list': frg_list},
                              context_instance=RequestContext(request))

#@login_required
def create_fragment(request, image_id):
    
    img = get_object_or_404(Image, id=image_id)
    
    frg1 = {"image": img, "path":"M 0 .5 L .5 0 L 1 .5 L .5 1 Z", "title":"Fragment X", "author":"juju"}
    frg2 = {"image": img, "path":"M .1 .3 L .5 .1 L .8 .7 Z", "title":"Fragment Y", "author":"loulou"}
    frg3 = {"image": img, "path":"M 0 .5 L .5 0 L 1 .5 L .5 1 Z", "title":"Fragment Z", "author":"juju"}
    frg4 = {"image": img, "path":"M .2 .5 L .7 .2 L .8 .7 Z", "title":"Fragment W", "author":"loulou"}
    frg_list = [frg1,frg2,frg3,frg4,frg3,frg4,frg1,frg4,frg3,frg4,frg1,frg2]
    
    
    return render_to_response("egonomy_create_fragment.html",
                              {'img': img, 'fragment_list': frg_list},
                              context_instance=RequestContext(request))

#@login_required
def save_fragment(request):
    
    frg_title = request.POST["fragment_title"]
    frg_desc = request.POST["fragment_description"]
    frg_kw = request.POST["users_keywords"]
    frg_path = request.POST["fragment_path"]
    frg_image_id = request.POST["image_id"]
    img = get_object_or_404(Image, id=frg_image_id)
    
    frg = Fragment()
    frg.image = img
    frg.coordinates = frg_path
    frg.title = frg_title
    frg.description = frg_desc
    frg.tags = frg_kw
    frg.author = request.user
    
    frg.save()
    
    return redirect("view_fragment", fragment_pk=frg.pk)



