$(function(){
//filters
	$('.filters a').each(function(){
		var text = $.trim($(this).text());
		if(text.length > 30){
			$(this).text(text.substr(0, 30) + '...')
		}
	});
//masonry
	var masonry465 = $('.masonry-465');
	masonry465.masonry({
	  columnWidth: 465,
	  itemSelector: '.item-masonry',
	  gutter : 20
	});

	var masonry225 = $('.masonry-225');
	masonry225.masonry({
	  columnWidth: 225,
	  itemSelector: '.item-masonry',
	  gutter : 16
	});

	function masonry177(){
		var masonry177 = $('.masonry-177');
		masonry177.masonry({
		  columnWidth: 177,
		  itemSelector: '.item-masonry'
		});
	}
	masonry177();
//popin
	$('.open-popin').bind('click', function(e){
		e.preventDefault();
		var target = $(this).attr('href');
		$('.popin-wrap').fadeIn(function(){
			$(target).show();
		});
	});

	$('.close-popin, .popin-wrap').bind('click', function(e){
		e.preventDefault();
		e.stopPropagation();
		$('.popin-wrap').fadeOut(function(){
			$('.popin').hide();
		});
	});

	$('.popin').bind('click', function(e){
		e.stopPropagation();
	});
//tag it
	if($('.tag-it').length){
		var keywordsTagIt = $('.tag-it').tagit({
			allowSpaces : true
		});
		$('.list-key-add a').bind('click', function(e){
			e.preventDefault();
			var tag = $(this).attr('data-tag');
			keywordsTagIt.tagit("createTag", tag);
		});
	}
//mosaic
	$('.toggle-comment').bind('click', function(e){
		e.preventDefault();
		$('.show-comment, .hide-comment').hide();
		if($('.mosaic').length){
			$('.mosaic').removeClass('mosaic').addClass('mosaic-comment');
			$('.hide-comment').show();
		}else{
			$('.mosaic-comment').removeClass('mosaic-comment').addClass('mosaic');
			$('.show-comment').show();
		}
		masonry177();
	});

	$('.display-keyword').bind('click', function(e){
		e.preventDefault();
		var ul = $(this).parents('ul'),
			li = $(this).parents('li'),
			iconAction = li.find('.icon-action'),
			index = li.index(),
			keyword = $(this).attr('data-keyword');
		enabledDisplayKeyword(li, keyword, iconAction);

		ul.find('li').each(function(k, v){
			if(index != k){
				var displayKeyword = $(v).find('.display-keyword'),
					iconAction = $(v).find('.icon-action'),
					keyword = displayKeyword.attr('data-keyword');
				disabledDisplayKeyword($(v), keyword, iconAction);
			}
		});
	});
	$('.icon-action').bind('click', function(e){
		e.preventDefault();
		var li = $(this).parents('li');
		toggleDisplayKeyword(li);
	});
	function toggleDisplayKeyword(li){
		var displayKeyword = li.find('.display-keyword'),
			iconAction = li.find('.icon-action'),
			keyword = displayKeyword.attr('data-keyword');
		if(li.hasClass('disabled')){
			enabledDisplayKeyword(li, keyword, iconAction);
		}else{
			disabledDisplayKeyword(li, keyword, iconAction);
		}
	}
	function enabledDisplayKeyword(li, keyword, iconAction){
		iconAction.removeClass('cross').removeClass('circle');
		li.removeClass('disabled');
		$('li.keyword-'+keyword).find('.curtain').hide();
		iconAction.addClass('cross');
	}
	function disabledDisplayKeyword(li, keyword, iconAction){
		iconAction.removeClass('cross').removeClass('circle');
		li.addClass('disabled');
		$('li.keyword-'+keyword).find('.curtain').show();
		iconAction.addClass('circle');
	}
//map
	if($('#map').length){
		var map = L.map('map').setView([51.505, -0.09], 13);
	}
});//ready
