$(function() {
    
    $('.masonry-177').masonry({
        columnWidth: 177,
        itemSelector: '.item-masonry'
    });
    
    function updateMasonry() {
        $('.masonry-177').masonry('layout');
    }
    
    var keywordsobj = {};
    
    $(".item-masonry").each(function(i, element) {
        $(element)
            .attr("data-keywords")
            .split(",")
            .forEach(function(kw) {
                var keyword = kw.replace(/(^\s+|\s+$)/g,''),
                    basekw = keyword.toLowerCase();
                if (!keywordsobj.hasOwnProperty(basekw)) {
                    keywordsobj[basekw] = {
                        keyword: keyword,
                        basekeyword: basekw,
                        count: 0,
                        items: $(),
                        enabled: true
                    };
                }
                kwobj = keywordsobj[basekw];
                kwobj.count++;
                kwobj.items.push(element);
            });
    });
    
    var keywordslist = [];
    
    for (var k in keywordsobj) {
        if (keywordsobj.hasOwnProperty(k)) {
            keywordslist.push(keywordsobj[k]);
        }
    }
    
    keywordslist.sort(function(a, b) {
        return b.count - a.count;
    });
    
    var filterlist = $(".filters");
    
    function updateKeywords() {
        var enabledItems = $();
        keywordslist.forEach(function(kw) {
            if (kw.enabled) {
                enabledItems = enabledItems.add(kw.items);
                kw.li.removeClass("disabled");
            } else {
                kw.li.addClass("disabled");
            }
        });
        $(".item-masonry").addClass("disabled");
        enabledItems.removeClass("disabled");
    }
    
    keywordslist.slice(0,100).forEach(function(kw) {
        var li = $('<li class="box-shadow-2">'),
            texta = $('<a class="display-keyword" href="#">'),
            actiona = $('<a class="icon-action" href="#">');
        texta.text(kw.keyword + ' ');
        li.append(actiona);
        li.append(texta);
        kw.li = li;
        li.click(function() {
            var allothersdisabled = keywordslist.reduce(function(mem, k) {
                return mem && (k === kw || !k.enabled);
            }, true);
            if (allothersdisabled) {
                keywordslist.forEach(function(k) {
                    k.enabled = true;
                });
            } else {
                keywordslist.forEach(function(k) {
                    k.enabled = false;
                });
                kw.enabled = true;
            }
            updateKeywords();
            return false;
        });
        actiona.click(function() {
            kw.enabled = !kw.enabled;
            updateKeywords();
            return false;
        });
        filterlist.append(li);
    })
        
    $('.toggle-comment').click(function(e){
        e.preventDefault();
        $('.show-comment, .hide-comment').hide();
        if($('.mosaic').length){
            $('.mosaic').removeClass('mosaic').addClass('mosaic-comment');
            $('.hide-comment').show();
        }else{
            $('.mosaic-comment').removeClass('mosaic-comment').addClass('mosaic');
            $('.show-comment').show();
        }
        updateMasonry();
    });

    //filters
    $('.filters a').each(function(){
        var text = $.trim($(this).text());
        if(text.length > 26){
            $(this).text(text.substr(0, 26) + '...')
        }
    });

//##################
/*
    $(document).on('click','.display-keyword', function(e){
        e.preventDefault();
        var ul = $(this).parents('ul'),
            li = $(this).parents('li'),
            iconAction = li.find('.icon-action'),
            index = li.index(),
            keyword = $(this).attr('data-keyword');
        
        if(!li.hasClass('disabled') && ul.find('li.disabled').length){
            ul.find('li').each(function(k, v){
                var displayKeyword = $(v).find('.display-keyword'),
                    iconAction = $(v).find('.icon-action'),
                    keyword = $.trim(displayKeyword.attr('data-keyword'));
                enabledDisplayKeyword($(v), keyword, iconAction);
            });
        }else{
            ul.find('li').each(function(k, v){
                if(index != k){
                    var displayKeyword = $(v).find('.display-keyword'),
                        iconAction = $(v).find('.icon-action'),
                        keyword = displayKeyword.attr('data-keyword');
                    disabledDisplayKeyword($(v), keyword, iconAction);
                }
            });
            enabledDisplayKeyword(li, keyword, iconAction);
        }
    });
    $('.icon-action').bind('click', function(e){
        e.preventDefault();
        var li = $(this).parents('li');
        toggleDisplayKeyword(li);
    });

    function toggleDisplayKeyword(li){
        var displayKeyword = li.find('.display-keyword'),
            iconAction = li.find('.icon-action'),
            keyword = displayKeyword.attr('data-keyword');
        if(li.hasClass('disabled')){
            enabledDisplayKeyword(li, keyword, iconAction);
        }else{
            disabledDisplayKeyword(li, keyword, iconAction);
        }
    }
    function enabledDisplayKeyword(li, keyword, iconAction){

        $('ul.mosaic > li').each(function(k, v){

            var keywords = $(v).attr('data-keywords'),
                item = $(v);
            keywords = keywords.split(',');
            for(var i=0; i<= keywords.length; i++){
                if($.trim(keywords[i]) == keyword){
                    item.find('.curtain').hide();
                }
            }
        });
        $('li.keyword-'+keyword).find('.curtain').hide();
        iconAction.addClass('cross');
    }
    function disabledDisplayKeyword(li, keyword, iconAction){

        $('ul.mosaic > li').each(function(k, v){

            var keywords = $(v).attr('data-keywords'),
                item = $(v);
            keywords = keywords.split(',');
            for(var i=0; i<= keywords.length; i++){
                if($.trim(keywords[i]) == keyword){
                    item.find('.curtain').show();
                }
            }
        });
        iconAction.addClass('circle');
    }
*/
});
