from django.conf import settings

import egonomy
from egonomy.auth import get_egonomy_token


def egonomy_context(request):
    egonomy_url = getattr(settings, 'EGONOMY_URL', '#')
    egonomy_token = get_egonomy_token(request)
    egonomy_token_name = ( getattr(settings, 'EGONOMY_TOKEN_NAME', 'egonomytoken') or 'egonomytoken')

    return {'VERSION': egonomy.get_version(), 'EGONOMY_URL': "%s?%s=%s" % (egonomy_url, egonomy_token_name, egonomy_token) if egonomy_token else egonomy_url }

