# -*- coding: utf-8 -*-
'''
Created on Feb 14, 2013

@author: ymh
'''

from django.core.paginator import Paginator, Page
from django.utils import six


class SearchPaginator(Paginator):
    
    def page(self, number):
        p = super(SearchPaginator, self).page(number)
        return SearchPage(p.object_list, p.number, self)


class SearchPage(Page):

    def __init__(self, object_list, number, paginator):
        super(SearchPage, self).__init__(object_list, number, paginator)
        self.evaluated_object_list = None

    def __getitem__(self, index):
        if not isinstance(index, (slice,) + six.integer_types):
            raise TypeError
        
        if self.evaluated_object_list is None:
            self.evaluated_object_list = [r.object for r in self.object_list]
        
        return self.evaluated_object_list[index]
    
    