# -*- coding: utf-8 -*-
'''
Created on Jan 28, 2013

@author: ymh
'''

from django.db import models
from django.contrib.auth.models import User

class ImageMetadata(models.Model):
    
    id = models.CharField(null=False, blank=False, max_length=15, primary_key=True)
    date_inserted = models.DateTimeField(null=False, blank=False, auto_now_add=True)
    date_modified = models.DateTimeField(null=False, blank=False, auto_now=True)
    
    cliche = models.CharField(null=False, blank=False, max_length=15)
    inventaire = models.TextField(null=True, blank=True)
    titre = models.TextField(null=True, blank=True)
    description = models.TextField(null=True, blank=True)
    date = models.IntegerField(null=True, blank=True)
    longueur = models.DecimalField(null=True, blank=True, max_digits=20, decimal_places=15)
    hauteur = models.DecimalField(null=True, blank=True, max_digits=20, decimal_places=15)
    profondeur = models.DecimalField(null=True, blank=True, max_digits=20, decimal_places=15)
    diametre = models.DecimalField(null=True, blank=True, max_digits=20, decimal_places=15)
    photographe = models.TextField(null=True, blank=True)
    auteur = models.TextField(null=True, blank=True)
    droits = models.TextField(null=True, blank=True)
    mentions = models.TextField(null=True, blank=True)
    periode = models.TextField(null=True, blank=True)
    technique = models.TextField(null=True, blank=True)
    site = models.TextField(null=True, blank=True)
    lieu = models.TextField(null=True, blank=True)
    localisation = models.TextField(null=True, blank=True)
    mots_cles = models.TextField(null=True, blank=True)
    
    titre_pertimm = models.TextField(null=True, blank=True)
    description_pertimm = models.TextField(null=True, blank=True)
    thesaurus_pertimm = models.TextField(null=True, blank=True)
    
    @property
    def thesaurus_pertimm_str(self):
        return self.thesaurus_pertimm.replace("|", ",")


class ImageInfo(models.Model):
    
    id = models.CharField(null=False, blank=False, max_length=15, primary_key=True)
    image_file = models.ImageField(width_field = "width", height_field= "height", upload_to="images/", max_length=2048)
    width = models.IntegerField(null=False, blank=False)
    height = models.IntegerField(null=False, blank=False)
    mimetype = models.CharField(null=True, blank=True, max_length=1024)
    exif = models.TextField(null=True, blank=True) #json value for exif data if available

    
class Image(models.Model):
    
    id = models.CharField(null=False, blank=False, max_length=15, primary_key=True)
    metadata = models.ForeignKey(ImageMetadata)
    info = models.ForeignKey(ImageInfo, null=True, blank=True)

    
class Fragment(models.Model):
    
    image = models.ForeignKey(Image, blank=False, null=False)
    date_created = models.DateTimeField(blank=False, null=False, auto_now_add=True)
    date_saved = models.DateTimeField(blank=False, null=False, auto_now=True)
    coordinates = models.TextField(blank=False, null=False)
    author = models.ForeignKey(User, blank=False, null=False)
    title = models.CharField(max_length=2048, blank=True, null=True)
    description = models.TextField(blank=True, null=True)
    tags = models.TextField(blank=True, null=True)
    