import base64
import datetime
import hashlib

from Crypto.Cipher import AES  # encryption library
from django.conf import settings
import pytz


def unix_time(dt):
    epoch = datetime.datetime.utcfromtimestamp(0).replace(tzinfo=pytz.UTC)
    delta = dt - epoch
    return delta.total_seconds()

BLOCK_SIZE = 32
# the character used for padding--with a block cipher such as AES, the value
# you encrypt must be a multiple of BLOCK_SIZE in length.  This character is
# used to ensure that your value is always a multiple of BLOCK_SIZE
PADDING = '{'

# one-liner to sufficiently pad the text to be encrypted
pad = lambda s: s + (BLOCK_SIZE - len(s) % BLOCK_SIZE) * PADDING

# create a cipher object using the random secret
cipher = AES.new(hashlib.md5(settings.SECRET_KEY).hexdigest())

# one-liners to encrypt/encode and decrypt/decode a string
# encrypt with AES, encode with base64
encodeAES = lambda s: base64.urlsafe_b64encode(cipher.encrypt(pad(s)))
decodeAES = lambda e: cipher.decrypt(base64.urlsafe_b64decode(e)).rstrip(PADDING)
