from django.conf import settings
from django.conf.urls import patterns, include, url
from django.conf.urls.static import static
from django.contrib.staticfiles.urls import staticfiles_urlpatterns

# Uncomment the next two lines to enable the admin:
from django.contrib import admin
admin.autodiscover()

urlpatterns = patterns('',
    url(r'^$', 'egonomy.views.home', name='home'),
    url(r'^annotate/$', 'egonomy.views.annotate_picture', name='annotate_picture'),
    url(r'^viewfragment/$', 'egonomy.views.view_fragment', name='view_fragment'),
    url(r'^createfragment/$', 'egonomy.views.create_fragment', name='create_fragment'),
    url(r'^savefragment/$', 'egonomy.views.save_fragment', name='save_fragment'),

    # Uncomment the admin/doc line below to enable admin documentation:
    url(r'^admin/doc/', include('django.contrib.admindocs.urls')),
    # Uncomment the next line to enable the admin:
    url(r'^admin/', include(admin.site.urls)),
)
urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)