from django.template import Library
from sorl.thumbnail import default
from sorl.thumbnail.images import ImageFile
from sorl.thumbnail.templatetags.thumbnail import safe_filter


register = Library()


@safe_filter(error_output=False)
@register.filter
def ratio(file_):
    """
    A very handy filter to determine if an image is portrait or landscape.
    """
    if not file_:
        return False
    image_file = default.kvstore.get_or_set(ImageFile(file_))
    return image_file.ratio
