# -*- coding: utf-8 -*-
'''
Created on Jan 31, 2013

@author: ymh
'''

from ..utils import show_progress
from django.core.management.base import BaseCommand, CommandError
from django.conf import settings
from egonomy.models import Image, ImageInfo, ImageMetadata
import os.path


class Command(BaseCommand):
    '''
    Export data in xml files
    '''

    args = 'path_to_folder'
    help = 'Export data to xml in senseetive format. Only one argument is needed : the folder where xml files will be saved.'
    
    
    def __safe_get(self, dict_arg, key, conv = lambda x: x, default= None):
        val = dict_arg.get(key, default)
        return conv(val) if val else default

    def __safe_decode(self, s):
        if not isinstance(s, basestring):
            return s
        try:
            return s.decode('utf8')
        except:
            try:
                return s.decode('latin1')
            except:
                return s.decode('utf8','replace')

    def handle(self, *args, **options):
        """
        <?xml version="1.0" encoding="UTF-8"?>
        <content>
            <title>T</title>
            <abstract>A</abstract>
            <keyword>KW 1/keyword>
            <keyword>KW 2</keyword>
            <keyword>KW 3</keyword>
            <!-- metadatas are : cliche, inventaire, date, longueur, hauteur, profondeur, diametre, photographe, auteur, 
                                 droits, mentions, periode, technique, site, lieu, localisation -->
            <metadata>
                <name>name of metadata 1</name>
                <value>value of metadata 1</value>
            </metadata>
            <metadata>
                <name>name of metadata 2</name>
                <value>name of metadata 2</value>
            </metadata>
        </content>

        """
        if len(args) != 1:
            raise CommandError("The command has no argument or too much arguments. Only one is needed : the folder where xml files will be saved.")
        
        path = args[0].rstrip(os.sep) + os.sep
        
        do_export = True
        if (not os.listdir(path)==[]) and not (len(os.listdir(path))==1 and os.listdir(path)[0]=='.DS_Store'):
            confirm = raw_input("""
    The folder already contains files or subfolders. The command will create a LOT of folders and xml files. Do you want to continue ?

    Type 'y' to continue, or 'n' to quit: """)
            do_export = (confirm == "y")
        
        if do_export:
            print("Beginning...")
            writer = None
            counter = 0
            print("Getting info from images...")
            img_list = Image.objects.all().select_related('info', 'metadata')
            nb_img = img_list.count()
            print("Creating xml files from %d images..." % nb_img)
            writer = show_progress(counter, nb_img, "", 40, writer)
            errors = []
            for img in img_list:
                counter += 1
                # An img.info.image_file path is like "images/XX/YYY.jpg" so we split and create XX folder and YYY.xml file path
                if img.info and img.info.image_file:
                    file_array = img.info.image_file.name.split("/")
                    file_folder = path + file_array[-2]
                    file_name = file_array[-1].split(".")[0] + ".xml"
                    if not os.path.isdir(file_folder):
                        os.makedirs(file_folder)
                    file_path = file_folder + os.sep + file_name
                else:
                    # If image_file is none, the xml file is put in path folder
                    file_path = path + img.id + ".xml"
                    errors.append(img.id + ".xml")
                    
                if os.path.exists(file_path):
                    os.remove(file_path)
                    
                # Open file
                fd = os.open(file_path, os.O_RDWR|os.O_CREAT)
                # Build xml string
                xml_str = u"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<content>\n\t<title>" + (img.metadata.titre if img.metadata.titre else "") + u"</title>\n\t<abstract>" + (img.metadata.description if img.metadata.description else "") + u"</abstract>\n"
                # tags
                if img.metadata.mots_cles:
                    tags = img.metadata.mots_cles.split(",")
                    for t in tags:
                        xml_str += u"\t<keyword>" + t.strip() + u"</keyword>\n"
                # metadatas
                xml_str += u"\t<metadata>\n\t\t<name>cliche<name>\n\t\t<value>" + (img.metadata.cliche if img.metadata.cliche else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>inventaire<name>\n\t\t<value>" + (img.metadata.inventaire if img.metadata.inventaire else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>date<name>\n\t\t<value>" + str((img.metadata.date if img.metadata.date else "")) + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>longueur<name>\n\t\t<value>" + str((img.metadata.longueur if img.metadata.longueur else "")) + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>hauteur<name>\n\t\t<value>" + str((img.metadata.hauteur if img.metadata.hauteur else "")) + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>profondeur<name>\n\t\t<value>" + str((img.metadata.profondeur if img.metadata.profondeur else "")) + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>diametre<name>\n\t\t<value>" + str((img.metadata.diametre if img.metadata.diametre else "")) + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>photographe<name>\n\t\t<value>" + (img.metadata.photographe if img.metadata.photographe else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>auteur<name>\n\t\t<value>" + (img.metadata.auteur if img.metadata.auteur else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>droits<name>\n\t\t<value>" + (img.metadata.droits if img.metadata.droits else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>mentions<name>\n\t\t<value>" + (img.metadata.mentions if img.metadata.mentions else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>periode<name>\n\t\t<value>" + (img.metadata.periode if img.metadata.periode else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>technique<name>\n\t\t<value>" + (img.metadata.technique if img.metadata.technique else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>site<name>\n\t\t<value>" + (img.metadata.site if img.metadata.site else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>lieu<name>\n\t\t<value>" + (img.metadata.lieu if img.metadata.lieu else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"\t<metadata>\n\t\t<name>localisation<name>\n\t\t<value>" + (img.metadata.localisation if img.metadata.localisation else "") + u"</value>\n\t</metadata>\n"
                xml_str += u"</content>"
                # Write xml string
                os.write(fd, xml_str.encode('utf8'))
                # Close opened file
                os.close(fd)
                # Show progress
                writer = show_progress(counter, nb_img, u"%s" % (file_name), 40, writer)
            # Show "errors" at the end : img that did not have image_file data and whom xml are put in root path folder.
            if len(errors)>0:
                print("Some entires had no image file and folder. The following xml files are in root folder %s :" % path)
                for e in errors:
                    print(e)
            print("End of export_to_xml command.")
        