from django.conf import settings
from django.conf.urls import patterns, include, url
from django.conf.urls.static import static
from django.contrib.staticfiles.urls import staticfiles_urlpatterns

# Uncomment the next two lines to enable the admin:
from django.contrib import admin
admin.autodiscover()

urlpatterns = patterns('',
    url(r'^$', 'egonomy.views.home', name='home'),
    url(r'^annotate/(?P<image_id>.*)/$', 'egonomy.views.annotate_picture', name='annotate_picture'),
    url(r'^viewfragment/(?P<fragment_pk>.*)/$', 'egonomy.views.view_fragment', name='view_fragment'),
    url(r'^createfragment/(?P<image_id>.*)/(?P<fragment_pk>.*)/$', 'egonomy.views.create_fragment', name='create_fragment'),
    url(r'^createfragment/(?P<image_id>.*)/', 'egonomy.views.create_fragment', name='create_fragment'),
    url(r'^savefragment/$', 'egonomy.views.save_fragment', name='save_fragment'),
    url(r'^allpictures/$', 'egonomy.views.all_pictures', name='all_pictures'),
    url(r'^allfragments/$', 'egonomy.views.all_fragments', name='all_fragments'),
    url(r'^userfragments/(?P<username>.*)/$', 'egonomy.views.user_fragments', name='user_fragments'),
    url(r'^senseetiveapi/$', 'egonomy.views.senseetive_api', name='senseetive_api'),
    url(r'^deletefragment/$', 'egonomy.views.delete_fragment', name='delete_fragment'),
    url(r'^allcollections/$', 'egonomy.views.all_collections', name='all_collections'),
    url(r'^usercollections/(?P<username>.*)/$', 'egonomy.views.user_collections', name='user_collections'),
    url(r'^savecollection/$', 'egonomy.views.save_collection', name='save_collection'),
    url(r'^deletecollection/$', 'egonomy.views.delete_collection', name='delete_collection'),
    url(r'^viewcollection/(?P<collection_pk>.*)/$', 'egonomy.views.view_collection', name='view_collection'),
    url(r'^additem/$', 'egonomy.views.add_item_to_collection', name='add_item'),
    url(r'^removeitem/$', 'egonomy.views.remove_item_from_collection', name='remove_item'),
    url(r'^embedslideshow/(?P<collection_pk>.*)/$', 'egonomy.views.embed_slideshow', name='embed_slideshow'),
    url(r'^picturebysearch/$', 'egonomy.views.picture_by_search', name='picture_by_search'),
    url(r'^fragmentbysearch/$', 'egonomy.views.fragment_by_search', name='fragment_by_search'),

    # Uncomment the admin/doc line below to enable admin documentation:
    url(r'^admin/doc/', include('django.contrib.admindocs.urls')),
    # Uncomment the next line to enable the admin:
    url(r'^admin/', include(admin.site.urls)),
    # login logout view
    url(r'^login/', 'django.contrib.auth.views.login', name='login'),
    url(r'^logout/', 'django.contrib.auth.views.logout', name='logout'),
)
urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)