from django.db import models
from django.contrib.auth.models import *


class Owner(models.Model):
    user = models.ForeignKey(User,  blank=True, null=True)
    group = models.ForeignKey(Group,  blank=True, null=True)

    def __unicode__(self):
        if self.user:
            return self.user.username
        else:
            return self.group.name


class Document(models.Model):
    owner= models.ForeignKey(Owner, blank = True, null=True)

    class Meta:
        abstract = True


