<?php
namespace CorpusParole\Providers;

use Illuminate\Support\ServiceProvider;
use CorpusParole\Libraries\Sparql\SparqlClient;
use CorpusParole\Libraries\Sparql\GuzzleSparqlClient;

/**
 * Service provider charged to bind repository interfaces to implementations
 */
class SparqlClientServiceProvider extends ServiceProvider {

    public function register() {
        $this->app->bind(
            'CorpusParole\Libraries\Sparql\SparqlClient',
            function($app) {
                $httpClient = new \GuzzleHttp\Client([ 'base_uri' => config('corpusparole.rdf4j_query_url'), 'http_errors' => false]);
                // we create another guzzle client to avoid interference with the base_uri parameter
                $sparqlClient = new GuzzleSparqlClient($app['Guzzle'], config('corpusparole.rdf4j_query_url'), config('corpusparole.rdf4j_update_url'));
                return new SparqlClient($httpClient, $sparqlClient);
            }
        );
    }
}
