import Ember from 'ember';
import layout from '../templates/components/doc-olac';
import DocLiteral from './doc-literal';
import * as utils from 'corpus-common-addon/utils/utils';

export default DocLiteral.extend({
  layout,
  classNames: ['doc-lit-olac'],
  olacUrl: Ember.computed('url', function () {
    const url = this.get('url');
    const value = this.get('value');

    const olacDef = utils.getOLACBaseUrl(url);

    if (!olacDef) {
      return '';
    }

    return olacDef.baseUrl + value;
  })
});
