import DS from 'ember-data';

export default DS.JSONSerializer.extend({

  normalizeResponse: function (store, primaryModelClass, payload) {
    var data = [];
    var discourses = payload['discourses'];
    Object.keys(discourses).forEach(function (key) {
      data.push({
        'id': key,
        'type': 'discourse',
        'attributes': {
          'label': discourses[key].label,
          'count': discourses[key].count
        }
      });
    });
    return {
      'data': data
    };
  }

});
