var selectTimeout;
var JQ = jQuery.noConflict();

function lighten(hex, lum) {
  return colorLuminance(hex, lum);
}
function darken(hex, lum) {
  return colorLuminance(hex, lum * -1);
}

function colorLuminance(hex, lum) {

  // validate hex string
  hex = String(hex).replace(/[^0-9a-f]/gi, '');
  if (hex.length < 6) {
    hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2];
  }
  lum = lum || 0;

  // convert to decimal and change luminosity
  var rgb = "#", c, i;
  for (i = 0; i < 3; i++) {
    c = parseInt(hex.substr(i * 2, 2), 16);
    c = Math.round(Math.min(Math.max(0, c + (c * lum)), 255)).toString(16);
    rgb += ("00" + c).substr(c.length);
  }

  return rgb;
}

function selectedColor(data_color, $el){
  if (JQ($el).hasClass('selected')) {
    JQ($el).css("background-color", data_color);
  }
  window.clearTimeout(selectTimeout);
}


JQ('.view-langues-isotope').ready(function () {
  var options = {
    "animation": true,
    "placement": "bottom",
    "trigger": "hover",
    "html": true,
    "template": '<div class="popover" role="tooltip"><div class="arrow"></div><div class="popover-content"></div></div>'
  };
  JQ('.isotope-options li[data-toggle=popover]', this).popover(options);
  JQ('.isotope-options li', this).each(function () {
    JQ('a.filterbutton', this).hover(
      function(){
        var data_color = JQ(this).attr("data-color");
        if(!JQ(this).hasClass('selected')){
          JQ(this).css("background-color", data_color);
        }
      },
      function(){
        if(!JQ(this).hasClass('selected')) {
          JQ(this).css("background-color", '#fff');
        }
      }
    );
    JQ('a.filterbutton', this).on('mouseup',function(){
      JQ('.isotope-options li a.filterbutton').css("background-color", '#fff');
      var data_color = JQ(this).attr("data-color");
      var $el = JQ(this);
      selectTimeout = window.setTimeout(function(){
        selectedColor(data_color, $el);
      }, 700);
    });
  });
//   JQ('.isotope-options li', this).each(function(){
// //		var data_content = JQ('span',this).attr("data-content");
// 		var data_color = JQ(this).attr("data-color");
//     JQ('a', this).css("background-color", data_color);
//     // var data_filter = JQ('a',this).attr("data-filter");
//     /*JQ(this)
//       .attr("data-toggle","popover")
//       .attr("data-content",data_content);*/
//     // if(data_color != "undefined"){
// 		// 	/*JQ('a',this)
// 		// 		//.css("background-color",lighten(data_color, 0.89))
// 		// 		//.css("border-color",lighten(data_color, -0.07))
// 		// 		.hover(
// 		// 			function(){
// 		// 				//JQ(this).css("background-color", lighten(data_color,
// 0.89));
// 		// 				JQ(this).css("background-color", lighten(data_color, 0.89));
// 		// 			},
// 		// 			function(){
// 		// 				JQ(this).css("background-color", "");
// 		// 			}
// 		// 		);	*/
// 		// 	// JQ('.isotope-element li').css("background-color",
// darken(data_color, 0.7)); // 	JQ('.isotope-options
// a').css("background-color", data_color); // }  });
});