import Ember from 'ember';
import layout from '../templates/components/doc-dcmi';
import * as constants from 'corpus-common-addon/utils/constants';
import * as utils from 'corpus-common-addon/utils/utils';

export default Ember.Component.extend({
  layout,
  tagName: 'span',
  code: Ember.computed('url', function () {
    const url = this.get('url');

    if (utils.isDCMILink(url)) {
      return url.substring(constants.DCMI_BASE_URL.length);
    }

    return url;
  })
});
