import { JSONAPISerializer } from 'ember-cli-mirage';

import _ from 'lodash';

export default JSONAPISerializer.extend({
    serialize(response, request) {

      let json = JSONAPISerializer.prototype.serialize.apply(this, arguments);

      let qParams = request.queryParams['discourse'];
      if(qParams) {
        json =  { 'data': _.map(json.data.slice(0, json.data.length/Math.pow(2,qParams.length)), (d) => {
          let res = _.clone(d);
          res.attributes.count = Math.max(Math.floor(d.attributes.count / 2), 1);
          return res;
        })};
      }

      return { 'discourses' : _(json.data).map((discourse) => {
        return [
          discourse.id,
          { count: discourse.attributes.count, label: discourse.attributes.label}
        ];
      }).fromPairs().value()};
    }
});
