<?php

/**
 * @file
 * Main view template.
 *
 * Variables available:
 * - $classes_array: An array of classes determined in
 *   template_preprocess_views_view(). Default classes are:
 *     .view
 *     .view-[css_name]
 *     .view-id-[view_name]
 *     .view-display-id-[display_name]
 *     .view-dom-id-[dom_id]
 * - $classes: A string version of $classes_array for use in the class attribute
 * - $css_name: A css-safe version of the view name.
 * - $css_class: The user-specified classes names, if any
 * - $header: The view header
 * - $footer: The view footer
 * - $rows: The results of the view query, if any
 * - $empty: The empty text to display if the view is empty
 * - $pager: The pager next/prev links to display, if any
 * - $exposed: Exposed widget form/info to display
 * - $feed_icon: Feed icon to display, if any
 * - $more: A link to view more, if any
 *
 * @ingroup views_templates
 */
//dpm($view);
?>
<div class="<?php print $classes; ?>">
  <?php print render($title_prefix); ?>
  <?php if ($title): ?>
    <?php print $title; ?>
  <?php endif; ?>
  <?php print render($title_suffix); ?>
  <?php if ($header): ?>
    <div class="view-header">
      <?php print $header; ?>
    </div>
  <?php endif; ?>

  <?php if(count($view->result) > 0): ?>  
  <ul class="isotope-container js-isotope" id="isotope-instance-langues">
    <?php foreach($view->result as $index => $row): ?>
      <li class="term<?php print $row->taxonomy_term_data_node_tid; ?> isotope-element">
        <div style="background-color: <?php print $row->field_field_type_lang_coloris[0]['raw']['rgb']; ?>;">
          <?php if(isset($row->field_field_langue_image[0]['rendered'])): ?>
            <?php print theme('image_style', array('style_name' => $row->field_field_langue_image[0]['rendered']['#image_style'], 'path' => $row->field_field_langue_image[0]['rendered']['#item']['uri'])); ?>          
          <?php else: ?>
            <?php print theme('image_style', array('style_name' => $row->field_field_type_lang_image[0]['rendered']['#image_style'], 'path' => $row->field_field_type_lang_image[0]['rendered']['#item']['uri'])); ?>          
          <?php endif; ?>
          <figcaption>
            <h2> <?php print $row->node_title; ?></h2>
            <p><?php print $row->field_field_langue_type_de_langue[0]['rendered']['#markup']; ?></p>
            <a href='<?php print drupal_get_path_alias('node/'.$row->nid); ?>'><?php print t('Voir plus'); ?></a>
          </figcaption>
        </div>
      </li>
    <?php endforeach; ?>
  </ul>
  <?php endif; ?>

</div><?php /* class view */ ?>