/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.LoadBalancedConnection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MultiHostConnectionProxy;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PingTarget;
import com.mysql.jdbc.ReplicationConnection;
import com.mysql.jdbc.ReplicationConnectionGroup;
import com.mysql.jdbc.ReplicationConnectionGroupManager;
import com.mysql.jdbc.ReplicationMySQLConnection;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationConnectionProxy
extends MultiHostConnectionProxy
implements PingTarget {
    private ReplicationConnection thisAsReplicationConnection;
    private NonRegisteringDriver driver;
    protected boolean enableJMX;
    protected boolean allowMasterDownConnections;
    protected boolean allowSlaveDownConnections;
    protected boolean readFromMasterWhenNoSlaves;
    protected boolean readFromMasterWhenNoSlavesOriginal;
    protected boolean readOnly;
    ReplicationConnectionGroup connectionGroup;
    private long connectionGroupID;
    private List<String> masterHosts;
    private Properties masterProperties;
    protected LoadBalancedConnection masterConnection;
    private List<String> slaveHosts;
    private Properties slaveProperties;
    protected LoadBalancedConnection slavesConnection;
    private static Constructor<?> JDBC_4_REPL_CONNECTION_CTOR;
    private static Class<?>[] INTERFACES_TO_PROXY;

    public static ReplicationConnection createProxyInstance(List<String> masterHostList, Properties masterProperties, List<String> slaveHostList, Properties slaveProperties) throws SQLException {
        ReplicationConnectionProxy connProxy = new ReplicationConnectionProxy(masterHostList, masterProperties, slaveHostList, slaveProperties);
        return (ReplicationConnection)Proxy.newProxyInstance(ReplicationConnection.class.getClassLoader(), INTERFACES_TO_PROXY, (InvocationHandler)connProxy);
    }

    private ReplicationConnectionProxy(List<String> masterHostList, Properties masterProperties, List<String> slaveHostList, Properties slaveProperties) throws SQLException {
        block16: {
            this.enableJMX = false;
            this.allowMasterDownConnections = false;
            this.allowSlaveDownConnections = false;
            this.readFromMasterWhenNoSlaves = false;
            this.readFromMasterWhenNoSlavesOriginal = false;
            this.readOnly = false;
            this.connectionGroupID = -1L;
            this.thisAsReplicationConnection = (ReplicationConnection)this.thisAsConnection;
            String enableJMXAsString = masterProperties.getProperty("replicationEnableJMX", "false");
            try {
                this.enableJMX = Boolean.parseBoolean(enableJMXAsString);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.badValueForReplicationEnableJMX", new Object[]{enableJMXAsString}), "S1009", null);
            }
            String allowMasterDownConnectionsAsString = masterProperties.getProperty("allowMasterDownConnections", "false");
            try {
                this.allowMasterDownConnections = Boolean.parseBoolean(allowMasterDownConnectionsAsString);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.badValueForAllowMasterDownConnections", new Object[]{allowMasterDownConnectionsAsString}), "S1009", null);
            }
            String allowSlaveDownConnectionsAsString = masterProperties.getProperty("allowSlaveDownConnections", "false");
            try {
                this.allowSlaveDownConnections = Boolean.parseBoolean(allowSlaveDownConnectionsAsString);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.badValueForAllowSlaveDownConnections", new Object[]{allowSlaveDownConnectionsAsString}), "S1009", null);
            }
            String readFromMasterWhenNoSlavesAsString = masterProperties.getProperty("readFromMasterWhenNoSlaves");
            try {
                this.readFromMasterWhenNoSlavesOriginal = Boolean.parseBoolean(readFromMasterWhenNoSlavesAsString);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.badValueForReadFromMasterWhenNoSlaves", new Object[]{readFromMasterWhenNoSlavesAsString}), "S1009", null);
            }
            String group = masterProperties.getProperty("replicationConnectionGroup", null);
            if (group != null) {
                this.connectionGroup = ReplicationConnectionGroupManager.getConnectionGroupInstance(group);
                if (this.enableJMX) {
                    ReplicationConnectionGroupManager.registerJmx();
                }
                this.connectionGroupID = this.connectionGroup.registerReplicationConnection(this.thisAsReplicationConnection, masterHostList, slaveHostList);
                this.slaveHosts = new ArrayList<String>(this.connectionGroup.getSlaveHosts());
                this.masterHosts = new ArrayList<String>(this.connectionGroup.getMasterHosts());
            } else {
                this.slaveHosts = new ArrayList<String>(slaveHostList);
                this.masterHosts = new ArrayList<String>(masterHostList);
            }
            this.driver = new NonRegisteringDriver();
            this.slaveProperties = slaveProperties;
            this.masterProperties = masterProperties;
            this.resetReadFromMasterWhenNoSlaves();
            try {
                this.initializeSlavesConnection();
            }
            catch (SQLException e) {
                if (this.allowSlaveDownConnections) break block16;
                throw e;
            }
        }
        try {
            this.currentConnection = this.initializeMasterConnection();
        }
        catch (SQLException e) {
            if (this.allowMasterDownConnections && this.slavesConnection != null) {
                this.readOnly = true;
                this.currentConnection = this.slavesConnection;
            }
            throw e;
        }
    }

    @Override
    MySQLConnection getNewWrapperForThisAsConnection() throws SQLException {
        if (Util.isJdbc4() || JDBC_4_REPL_CONNECTION_CTOR != null) {
            return (MySQLConnection)Util.handleNewInstance(JDBC_4_REPL_CONNECTION_CTOR, new Object[]{this}, null);
        }
        return new ReplicationMySQLConnection(this);
    }

    @Override
    protected void propagateProxyDown(MySQLConnection proxyConn) {
        if (this.masterConnection != null) {
            this.masterConnection.setProxy(proxyConn);
        }
        if (this.slavesConnection != null) {
            this.slavesConnection.setProxy(proxyConn);
        }
    }

    @Override
    boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        return false;
    }

    @Override
    public boolean isMasterConnection() {
        return this.currentConnection != null && this.currentConnection == this.masterConnection;
    }

    public boolean isSlavesConnection() {
        return this.currentConnection != null && this.currentConnection == this.slavesConnection;
    }

    @Override
    void pickNewConnection() throws SQLException {
    }

    @Override
    void doClose() throws SQLException {
        MySQLConnection prevConnection = this.currentConnection;
        if (this.masterConnection != null) {
            this.currentConnection = this.masterConnection;
            this.masterConnection.close();
        }
        if (this.slavesConnection != null) {
            this.currentConnection = this.slavesConnection;
            this.slavesConnection.close();
        }
        this.currentConnection = prevConnection;
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this.thisAsReplicationConnection);
        }
    }

    @Override
    void doAbortInternal() throws SQLException {
        this.masterConnection.abortInternal();
        this.slavesConnection.abortInternal();
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this.thisAsReplicationConnection);
        }
    }

    @Override
    void doAbort(Executor executor) throws SQLException {
        this.masterConnection.abort(executor);
        this.slavesConnection.abort(executor);
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this.thisAsReplicationConnection);
        }
    }

    @Override
    Object invokeMore(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke((Object)this.thisAsConnection, args);
        if (result != null && result instanceof Statement) {
            ((Statement)result).setPingTarget(this);
        }
        return result;
    }

    @Override
    public void doPing() throws SQLException {
        SQLException slavesPingException;
        SQLException mastersPingException;
        boolean isMasterConn;
        block16: {
            isMasterConn = this.isMasterConnection();
            mastersPingException = null;
            slavesPingException = null;
            if (this.masterConnection != null) {
                try {
                    this.masterConnection.ping();
                }
                catch (SQLException e) {
                    mastersPingException = e;
                }
            } else {
                this.initializeMasterConnection();
            }
            if (this.slavesConnection != null) {
                try {
                    this.slavesConnection.ping();
                }
                catch (SQLException e) {
                    slavesPingException = e;
                }
            } else {
                try {
                    this.initializeSlavesConnection();
                    if (this.switchToSlavesConnectionIfNecessary()) {
                        isMasterConn = false;
                    }
                }
                catch (SQLException e) {
                    if (this.readFromMasterWhenNoSlaves) break block16;
                    throw e;
                }
            }
        }
        if (isMasterConn && mastersPingException != null) {
            if (this.slavesConnection != null && slavesPingException == null) {
                this.masterConnection = null;
                this.currentConnection = this.slavesConnection;
                this.readOnly = true;
            }
            throw mastersPingException;
        }
        if (!(isMasterConn || slavesPingException == null && this.slavesConnection != null)) {
            if (this.readFromMasterWhenNoSlaves && mastersPingException == null) {
                this.slavesConnection = null;
                this.currentConnection = this.masterConnection;
                this.readOnly = true;
                this.currentConnection.setReadOnly(true);
            }
            if (slavesPingException != null) {
                throw slavesPingException;
            }
        }
    }

    private MySQLConnection initializeMasterConnection() throws SQLException {
        this.masterConnection = null;
        if (this.masterHosts.size() == 0) {
            return null;
        }
        LoadBalancedConnection newMasterConn = (LoadBalancedConnection)this.driver.connect(this.buildURL(this.masterHosts, this.masterProperties), this.masterProperties);
        newMasterConn.setProxy(this.getProxy());
        this.masterConnection = newMasterConn;
        return this.masterConnection;
    }

    private MySQLConnection initializeSlavesConnection() throws SQLException {
        this.slavesConnection = null;
        if (this.slaveHosts.size() == 0) {
            return null;
        }
        LoadBalancedConnection newSlavesConn = (LoadBalancedConnection)this.driver.connect(this.buildURL(this.slaveHosts, this.slaveProperties), this.slaveProperties);
        newSlavesConn.setProxy(this.getProxy());
        newSlavesConn.setReadOnly(true);
        this.slavesConnection = newSlavesConn;
        return this.slavesConnection;
    }

    private String buildURL(List<String> hosts, Properties props) {
        StringBuilder url = new StringBuilder("jdbc:mysql:loadbalance://");
        boolean firstHost = true;
        for (String host : hosts) {
            if (!firstHost) {
                url.append(',');
            }
            url.append(host);
            firstHost = false;
        }
        url.append("/");
        String masterDb = props.getProperty("DBNAME");
        if (masterDb != null) {
            url.append(masterDb);
        }
        return url.toString();
    }

    private synchronized void switchToMasterConnection() throws SQLException {
        if (this.masterConnection == null || this.masterConnection.isClosed()) {
            try {
                this.initializeMasterConnection();
            }
            catch (SQLException e) {
                this.currentConnection = null;
                throw e;
            }
        }
        if (!this.isMasterConnection() && this.masterConnection != null) {
            ReplicationConnectionProxy.syncSessionState(this.currentConnection, this.masterConnection, false);
            this.currentConnection = this.masterConnection;
        }
    }

    private synchronized void switchToSlavesConnection() throws SQLException {
        if (this.slavesConnection == null || this.slavesConnection.isClosed()) {
            try {
                this.initializeSlavesConnection();
            }
            catch (SQLException e) {
                this.currentConnection = null;
                throw e;
            }
        }
        if (!this.isSlavesConnection() && this.slavesConnection != null) {
            ReplicationConnectionProxy.syncSessionState(this.currentConnection, this.slavesConnection, true);
            this.currentConnection = this.slavesConnection;
        }
    }

    private boolean switchToSlavesConnectionIfNecessary() throws SQLException {
        if (this.isMasterConnection() && this.readOnly) {
            this.switchToSlavesConnection();
            return true;
        }
        return false;
    }

    public synchronized Connection getCurrentConnection() {
        return this.currentConnection;
    }

    public long getConnectionGroupId() {
        return this.connectionGroupID;
    }

    public synchronized Connection getMasterConnection() {
        return this.masterConnection;
    }

    public synchronized void promoteSlaveToMaster(String host) throws SQLException {
        this.masterHosts.add(host);
        this.removeSlave(host);
        if (this.masterConnection != null) {
            this.masterConnection.addHost(host);
        }
    }

    public synchronized void removeMasterHost(String host) throws SQLException {
        this.removeMasterHost(host, true);
    }

    public synchronized void removeMasterHost(String host, boolean waitUntilNotInUse) throws SQLException {
        this.removeMasterHost(host, waitUntilNotInUse, false);
    }

    public synchronized void removeMasterHost(String host, boolean waitUntilNotInUse, boolean isNowSlave) throws SQLException {
        if (isNowSlave) {
            this.slaveHosts.add(host);
            this.resetReadFromMasterWhenNoSlaves();
        }
        this.masterHosts.remove(host);
        if (this.masterConnection == null || this.masterConnection.isClosed()) {
            this.masterConnection = null;
            return;
        }
        if (waitUntilNotInUse) {
            this.masterConnection.removeHostWhenNotInUse(host);
        } else {
            this.masterConnection.removeHost(host);
        }
    }

    public boolean isHostMaster(String host) {
        if (host == null) {
            return false;
        }
        for (String masterHost : this.masterHosts) {
            if (!masterHost.equalsIgnoreCase(host)) continue;
            return true;
        }
        return false;
    }

    public synchronized Connection getSlavesConnection() {
        return this.slavesConnection;
    }

    public synchronized void addSlaveHost(String host) throws SQLException {
        if (this.isHostSlave(host)) {
            return;
        }
        this.slaveHosts.add(host);
        this.resetReadFromMasterWhenNoSlaves();
        if (this.slavesConnection == null) {
            this.initializeSlavesConnection();
            this.switchToSlavesConnectionIfNecessary();
        } else {
            this.slavesConnection.addHost(host);
        }
    }

    public synchronized void removeSlave(String host) throws SQLException {
        this.removeSlave(host, true);
    }

    public synchronized void removeSlave(String host, boolean closeGently) throws SQLException {
        this.slaveHosts.remove(host);
        this.resetReadFromMasterWhenNoSlaves();
        if (this.slavesConnection == null || this.slavesConnection.isClosed()) {
            this.slavesConnection = null;
            return;
        }
        if (closeGently) {
            this.slavesConnection.removeHostWhenNotInUse(host);
        } else {
            this.slavesConnection.removeHost(host);
        }
        if (this.slaveHosts.isEmpty()) {
            this.slavesConnection.close();
            this.slavesConnection = null;
            this.switchToMasterConnection();
            this.currentConnection.setReadOnly(this.readOnly);
        }
    }

    public boolean isHostSlave(String host) {
        if (host == null) {
            return false;
        }
        for (String test : this.slaveHosts) {
            if (!test.equalsIgnoreCase(host)) continue;
            return true;
        }
        return false;
    }

    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            if (!this.isSlavesConnection() || this.currentConnection.isClosed()) {
                try {
                    this.switchToSlavesConnection();
                }
                catch (SQLException e) {
                    if (this.readFromMasterWhenNoSlaves) {
                        this.switchToMasterConnection();
                    }
                    throw e;
                }
            }
        } else if (!this.isMasterConnection() || this.currentConnection.isClosed()) {
            this.switchToMasterConnection();
        }
        this.readOnly = readOnly;
        if (this.readFromMasterWhenNoSlaves && this.isMasterConnection()) {
            this.currentConnection.setReadOnly(this.readOnly);
        }
    }

    public boolean isReadOnly() throws SQLException {
        return !this.isMasterConnection() || this.readOnly;
    }

    private void resetReadFromMasterWhenNoSlaves() {
        this.readFromMasterWhenNoSlaves = this.slaveHosts.isEmpty() || this.readFromMasterWhenNoSlavesOriginal;
    }

    static {
        if (Util.isJdbc4()) {
            try {
                JDBC_4_REPL_CONNECTION_CTOR = Class.forName("com.mysql.jdbc.JDBC4ReplicationMySQLConnection").getConstructor(ReplicationConnectionProxy.class);
                INTERFACES_TO_PROXY = new Class[]{ReplicationConnection.class, Class.forName("com.mysql.jdbc.JDBC4MySQLConnection")};
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            INTERFACES_TO_PROXY = new Class[]{ReplicationConnection.class};
        }
    }
}

