import * as constants from 'corpus-common-addon/utils/constants';

import ResolverService from 'corpus-common-addon/services/resolver-service';

export default ResolverService.extend({

    storeKeyBase: 'lexvo',
    apiPath:  '/api/v1/resolvers/lexvo/',
    resDocRoot: 'lexvoids',

    init() {
        this._super(...arguments);
    },

    processId: function(id) {
        var lexvoId = id;
        if(id.startsWith(constants.LEXVO_BASE_URL)) {
            lexvoId = id.slice(constants.LEXVO_BASE_URL.length);
        }
        return lexvoId;
    },

    getReturnDictKey: function(id) { return id; }

});
