<?php

namespace CorpusParole\Providers;

use Illuminate\Support\ServiceProvider;
use GuzzleHttp\Client;

/**
 * guzzle Service Provider, inspired by https://github.com/urakozz/laravel-guzzle
 */
class GuzzleServiceProvider extends ServiceProvider
{
    /**
     * Register the Guzzle provider
     *
     * @return GuzzleClient
     */
    public function register()
    {
        $this->app->bind('Guzzle', function() {
            $config = isset($this->app['config']['guzzle']) ? $this->app['config']['guzzle'] : [];
            return new Client($config);
        });
    }
}
