<?php
namespace CorpusParole\Repositories;

use CorpusParole\Models\Document;

interface DocumentRepository {

    public function all();

    public function get($id, $short = false);

    public function save(Document $doc);

    /**
     * Paginate all document as a paginator.
     *
     * @param  int  $perPage
     * @param  string  $pageName
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function paginateAll($perPage = 15, $pageName = 'page', $page = null);

    /**
     * Paginate filtered document as a paginator.
     *
     * @param  array $filters
     * @param  int  $perPage
     * @param  string  $pageName
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function paginate($filters = [], $perPage = 15, $pageName = 'page', $page = null, $sort = null);


    /**
     * Resolve lexvo id for all documents in the list
     * this allow to optimise the call of lexvo repository
     * This will modify the documents.
     *
     * @param array
     * @return nothing
     */
    public function resolveLexvo(Array $docList);

    /**
     * Add country info for document.
     * This modify the document
     *
     * @param $doc the document instance
     * @return nothing
     */
    public function addCountryInfo($doc);

    public function getCount();
}
