<?php

use Mockery as m;

use CorpusParole\Services\BnfResolverException;

/**
 *
 */
class BnfControllerTest extends TestCase {

    private $bnfResolver;

    public function setUp() {

        parent::setup();

        // create a mock of the post repository interface and inject it into the
        // IoC container
        $this->bnfResolver = m::mock('CorpusParole\Services\BnfResolverInterface');
        $this->app->instance('CorpusParole\Services\BnfResolverInterface', $this->bnfResolver);
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testSetup() {
        //do nothing jsut test setup & teardown
    }

    public function testShow() {
        $this->bnfResolver
            ->shouldReceive('getLabels')
            ->with(['ark:/12148/cb11946662b', 'ark:/12148/cb11965628b'])
            ->once()
            ->andReturn([
                'ark:/12148/cb11946662b' => 'parents et enfants',
                'ark:/12148/cb11965628b' => 'frères et soeurs'
            ]);
        $response = $this->get('/api/v1/resolvers/bnf/cb11946662b,cb11965628b')->
            assertJson(['bnfids' => [
                'ark:/12148/cb11946662b' => 'parents et enfants',
                'ark:/12148/cb11965628b' => 'frères et soeurs'
            ]]);
    }

    public function testShowOne() {
        $this->bnfResolver
            ->shouldReceive('getLabels')
            ->with(['ark:/12148/cb11946662b'])
            ->once()
            ->andReturn([
                'ark:/12148/cb11946662b' => 'parents et enfants'
            ]);
        $response = $this->get('/api/v1/resolvers/bnf/cb11946662b')->
            assertJson(['bnfids' => [
                'ark:/12148/cb11946662b' => 'parents et enfants'
            ]]);
    }

    public function testShowUnknown() {
        $this->bnfResolver
            ->shouldReceive('getLabels')
            ->with(['ark:/12148/cb12345678b'])
            ->once()
            ->andReturn([
                'ark:/12148/cb12345678b' => null
            ]);
        $response = $this->get('/api/v1/resolvers/bnf/cb12345678b')->
            assertJson(['bnfids' => [
                'ark:/12148/cb12345678b' => null
            ]]);
    }

    public function testShowMalformed() {
        $this->bnfResolver
            ->shouldReceive('getLabels')
            ->with(['ark:/12148/abcdef','ark:/12148/ghij'])
            ->once()
            ->andThrow('CorpusParole\Services\BnfResolverException', "BnfId not in correct format", 500);
        $response = $this->get('/api/v1/resolvers/bnf/abcdef,ghij');

        $response->assertStatus(500);
    }

}
