import Ember from 'ember';
import * as constants from 'corpus-common-addon/utils/constants'

export function getLinkType(params/*, hash*/) {
  let url = params[0];

  if(!url) {
    return 'doc-generic';  
  }
  if(url.startsWith(constants.LEXVO_BASE_URL)) {
    return 'doc-language';
  }
  if(
    url.startsWith(constants.BNF_BASE_URL) ||
    url.startsWith(constants.BNF_ARK_BASE_URL) ||
    url.startsWith(constants.BNF_ARK_BASE_ID))
  {
    return 'doc-subject';
  }
  return 'doc-generic';
}

export default Ember.Helper.helper(getLinkType);
