import Ember from 'ember';

export default Ember.Controller.extend({
  queryParams: ['location', 'langue', 'discours', 'date', 'thematique'],
  location: null,
  langue: null,
  discours: null,
  date: [],
  thematique: null,
  isShowingModal: false,
  currentDetails: null,
  currentItem: {title: "example", master: 'http://www.noiseaddicts.com/samples_1w72b820/3921.mp3'},
  filteredDocuments: Ember.computed('location', 'langue', 'discours', 'date', 'thematique', 'model', function() {
    var location = this.get('location');
    var langue = this.get('langue');
    var discours = this.get('discours');
    var date = this.get('date');
    var thematique = this.get('thematique');

    var documents = this.get('model');

    if (location) {
      documents = documents.filterBy('spatial', location);
    }
    if (langue) {
      documents = documents.filterBy('language', langue);
    }
    if (discours) {
      documents = documents.filterBy('type', discours);
    }
    if (date.length > 0) {
      var temp = documents;
      documents.map(function(elt){
        if (date.indexOf(elt.get('created')) === -1){
          temp = temp.without(elt);
        }
      });
      documents = temp;
    }
    if (thematique) {
      documents = documents.filterBy('thematique', thematique);
    }
    return documents;
  }),
  currentItemChanged: Ember.observer('currentItem', function() {
    Ember.$(".result-item").toggleClass("playing", false);
    Ember.$("#"+this.get('currentItem').id).toggleClass("playing", true);
  }),
  actions: {
    deleteTag: function(query, item){
      var newParams = null;

      if (query === 'date'){
        newParams = [];
        Ember.$.each(this.get('date'), function(index, elt){
          if (elt !== item){
            newParams.push(elt);
          }
        });
      }

      this.set(query, newParams);
    },
    changeDocument: function(docDirection){
      var direction = (docDirection === "next") ? 1 : -1;
      var index = this.get("filteredDocuments").indexOf(this.get("currentItem"));
      if ( index !== -1){
          if (typeof(this.get("filteredDocuments").objectAt(index+direction)) !== 'undefined'){
            return this.set('currentItem', this.get("filteredDocuments").objectAt(index+direction));
          }
      }
      return this.set('currentItem', this.get('filteredDocuments').get('firstObject'));
    },
    play: function(item){
      this.set("currentItem", item);
    },
    details: function(item){
      if (Ember.$("#"+item.id).hasClass("details")){
          Ember.$("#"+item.id).toggleClass("details", false);
      } else{
        Ember.$(".result-item").toggleClass("details", false);
        Ember.$("#"+item.id).toggleClass("details", true);
      }
    },
    toggleModal: function(item){
      this.set("isShowingModal", !this.isShowingModal);
      this.set("currentDetails", item);
    }
  }
});
