<?php

/**
 * @file
 * Main view template.
 *
 * Variables available:
 * - $classes_array: An array of classes determined in
 *   template_preprocess_views_view(). Default classes are:
 *     .view
 *     .view-[css_name]
 *     .view-id-[view_name]
 *     .view-display-id-[display_name]
 *     .view-dom-id-[dom_id]
 * - $classes: A string version of $classes_array for use in the class attribute
 * - $css_name: A css-safe version of the view name.
 * - $css_class: The user-specified classes names, if any
 * - $header: The view header
 * - $footer: The view footer
 * - $rows: The results of the view query, if any
 * - $empty: The empty text to display if the view is empty
 * - $pager: The pager next/prev links to display, if any
 * - $exposed: Exposed widget form/info to display
 * - $feed_icon: Feed icon to display, if any
 * - $more: A link to view more, if any
 *
 * @ingroup views_templates
 */
//dpm($view);
?>
<div class="<?php print $classes; ?>">

<?php if (count($view->result) > 0): ?>
    <ul class="isotope-options clearfix" data-filter-group="unnamed_filter">
        <li class="first" data-color="#5cb85c"><a href="#filter" style="background-color: #5cb85c" class="filterbutton selected"
                             data-filter="" data-color="#5cb85c"><?php print t('Tout'); ?></a></li>
      <?php foreach ($view->result as $index => $row): ?>
          <li <?php if ($row->field_description_field[0]['raw']['value'] != '') { ?> data-toggle="popover" data-content="<?php print $row->field_description_field[0]['raw']['value']; ?>" data-original-title="<?php print $row->taxonomy_term_data_name; ?>" <?php } ?>
                  title="<?php print $row->taxonomy_term_data_name; ?>"
                  data-color="<?php print $row->field_field_type_lang_coloris[0]['raw']['rgb']; ?>">
              <!--          <a style="background-color: -->
            <?php //print $row->field_field_type_lang_coloris[0]['raw']['rgb']; ?><!--" href="#filter" class="filterbutton" data-filter=".term-->
            <?php //print $row->tid; ?><!--">-->
              <a href="#filter" class="filterbutton"
                 data-filter=".term<?php print $row->tid; ?>"
                 data-color="<?php print $row->field_field_type_lang_coloris[0]['raw']['rgb']; ?>">
                <?php print $row->taxonomy_term_data_name; ?>
              </a>
          </li>
      <?php endforeach; ?>
    </ul>
<?php endif; ?>

    </div><?php /* class view */ ?>