<?php
namespace CorpusParole\Services;

use CorpusParole\Models\Document;

use GuzzleHttp\Client;

class TranscriptManager implements TranscriptManagerInterface {

    public function __construct(Client $client) {
        $this->client = $client;
    }


    public function getConverterUrl($converterKey, Document $document, $url) {

        $response = $this->client->get($url);
        $statusCode = $response->getStatusCode();
        if($statusCode < 200 || $statusCode > 299 ) {
            throw new TranscriptManagerException("Can not get transcript content : $statusCode -> ".$response->getReasonPhrase());
        }

        return $this->getConverter($converterKey, $document, $response->getBody());

    }

    public function getConverter($converterKey, Document $document, $source) {

        $converterClassMapping = config('corpusparole.transcrit_decoder_mapping');
        if(!array_key_exists($converterKey, $converterClassMapping)) {
            throw new TranscriptManagerException("Transcript type $converterKey doe not exists");
        }
        $converterClass = $converterClassMapping[$converterKey];
        if(empty($converterClass)) {
            throw new TranscriptManagerException("Transcript type $converterKey doe not exists (empty class)");
        }

        return new $converterClass($document, $source);

    }
}
