#!/bin/bash
#
clear
TARFILE=sources.tar.gz
DUMP=corpusdelaparole.sql
APUSER=apache
APGROUP=apache
# Variable de configuration à modifier selon vos besoins
#########################################################
ROOT=/var/www/corpusdelaparole/drupal/
#########################################################

export DRUSH_OPTIONS="-q"
echo "--------------------------- PARAMETRES D'INSTALLATION -------------------------------------------------------"
echo "------------ A modifier dans le fichier sites/default/settings.php au besoin --------------------------------"
echo "-------------------------------------------------------------------------------------------------------------"
drush -r $ROOT sql-conf
echo "-------------------------------------------------------------------------------------------------------------"
echo "-------------------------------------------------------------------------------------------------------------"
read -r -p "Etes-vous sur(e) de vouloir exporter avec les paramètres ci dessus ? [Oui/n]" response
 response=${response,,} # tolower
 if [[ $response =~ ^(oui|o| ) ]]; then
    #
    echo ""
    echo ""
    echo "-------------------- Exportation du site corpus de la parole -----------------------------------------------"
    echo "-------------------------------------------------------------------------------------------------------------"
    #
    # Errors are fatal
    #
    set -e

    echo "Archive des sources de $ROOT"
    echo "---------------------------------"
    if [ -d "${ROOT%/}/sites/default/private" ]; then
        tar zcvf sources.tar.gz -C "$ROOT" ./sites/default/files ./sites/default/private
    else
        tar zcvf sources.tar.gz -C "$ROOT" ./sites/default/files
    fi

    echo "Export de la base de donnée"
    echo "---------------------------------"
    drush -r $ROOT sql-dump > corpusdelaparole.sql

    echo ""
    echo ""
    echo ">>>>>>>>>>>>>> EXPORT EFFECTUEE AVEC SUCCESS"
    echo ""
    echo ""
fi


