#!/usr/bin/env bash

mkdir -p /vagrant/dist
pushd /vagrant/dist > /dev/null
echo "---> Launching packaging for puppet"
rm -f puppet-corpusdelaparole*.rpm
rm -f bootstrap-puppet.sh

version=$(grep -oP "\'version\'\s*=>\s*\'\K[\.0-9]+(?=\')" /vagrant/root/var/www/corpusdelaparole/corpus-back/config/version.php)
version=${version:-0.0.0}

fpm \
    --verbose \
    -a all \
    -s dir \
    -t rpm \
    -C /vagrant/root-puppet \
    -d puppet \
    -d puppetlabs-release \
    --name puppet-corpusdelaparole \
    --version "$version" \
    --iteration $(date +%s) \
    --description "corpus de la Parole : RPM package for puppet provisioning files" \
    --url "http://corpusdelaparole.huma-num.fr" \
    --rpm-user puppet \
    --rpm-group puppet \
    --directories /var/lib/puppet/provision \
    .

echo "---> Packaging for puppet done"
echo "---> Copy puppet bootstrap"
cp /vagrant/root-puppet/var/lib/puppet/provision/bootstrap-puppet.sh .

popd > /dev/null

