import Ember from 'ember';
import * as utils from 'corpus-common-addon/utils/utils'

export function getLinkType(params/*, hash*/) {
  let url = params[0];

  if(!url) {
    return 'doc-literal';
  }
  if(utils.isLexvoLink(url)) {
    return 'doc-language';
  }
  if(utils.isBnfLink(url)) {
    return 'doc-subject';
  }
  return 'doc-literal';
}

export default Ember.Helper.helper(getLinkType);
