import Ember from 'ember';
import AmCharts from 'ammaps';
import ENV from 'app-client/config/environment';

export default Ember.Component.extend({

    map: null,

    continentsMapVar: AmCharts.maps.continentsLow,
    continentsAreas: [],
    countriesMapVar: AmCharts.maps.worldLow,
    countriesAreas: [],
    franceMapVar: AmCharts.maps.france2016Low,
    franceAreas: [],

    color: 'rgba(113,132,141,.2)',

    locationId: 'world',

    filter: Ember.inject.service(),
    locationObserver: Ember.observer('filter.location', function() {
        if(!this.get('filter').get('location')) {
            this.get('map').selectObject();
        }
    }),

    geostats: [],
    observerGeostats: Ember.observer('geostats', function() {
        if(this.get('map')) {
            if(this.get('map').selectedObject.id) {
                if(this.get('map').selectedObject.parentObject.mapVar === this.get('countriesMapVar')) {
                    if(this.get('map').selectedObject.id === 'FR') {
                        this.setFranceAreas();
                        this.get('map')['dataProvider'] = {
                            'mapVar': this.get('franceMapVar'),
                            'getAreasFromMap': true,
                            'areas': this.get('franceAreas')
                        };
                        this.get('map').validateData();
                    }
                } else if(this.get('map').selectedObject.parentObject.mapVar === this.get('continentsMapVar')) {
                    this.setCountriesAreas();
                    this.get('map')['dataProvider'] = {
                        'mapVar': this.get('countriesMapVar'),
                        'getAreasFromMap': true,
                        'areas': this.get('countriesAreas'),
                        'zoomLevel': this.get('map').zoomLevel(),
                        'zoomLatitude': this.get('map').zoomLatitude(),
                        'zoomLongitude': this.get('map').zoomLongitude()
                    };
                    this.get('map').validateData();
                }
            } else {
                this.createAmMap();
            }
        }
    }),

    init: function() {
        this._super(...arguments);
        if (ENV.environment === 'development') {
            this.set('color', 'rgba(141,113,113,.2)');
        }
    },

    setFranceAreas: function() {
        var self = this;
        var france2016LowAreas = [];
        this.get('franceMapVar')['svg']['g']['path'].forEach(function(area) {
            var object = {
                'id': area.id,
                'passZoomValuesToTarget': false,
                'autoZoom': false
            };
            if(self.get('geostats').findIndex(geostat => geostat.id === area.id) === -1) {
                object['mouseEnabled'] = false,
                object['color'] = self.get('color');
            }
            france2016LowAreas.push(object);
        });
        this.set('franceAreas', france2016LowAreas);
    },

    setCountriesAreas: function() {
        var self = this;
        var worldLowAreas = [];
        this.get('countriesMapVar')['svg']['g']['path'].forEach(function(area) {
            if(self.get('geostats').findIndex(geostat => geostat.id === area.id) === -1) {
                worldLowAreas.push({
                    'id': area.id,
                    'mouseEnabled': false,
                    'color': self.get('color')
                });
            } else {
                if(typeof worldLowAreas.find(country => country.id === area.id) === 'undefined') {
                    var object = {
                        'id': area.id,
                        'selectable': true
                    };
                    if(area.id === 'FR') {
                        object['autoZoom'] = true;
                    }
                    worldLowAreas.push(object);
                }
            }
        });
        this.set('countriesAreas', worldLowAreas);
    },

    setContinentsAreas: function() {
        var self = this;
        var continentsLowAreas = [];
        this.get('continentsMapVar')['svg']['g']['path'].forEach(function(area) {
            var object = {
                'id': area.id,
                'passZoomValuesToTarget': true,
                'selectable': true,
                'mouseEnabled': true,
                'autoZoom': true
            };
            if(self.get('geostats').findIndex(geostat => geostat.id === area.id) === -1) {
                object['mouseEnabled'] = false,
                object['color'] = self.get('color');
            }
            continentsLowAreas.push(object);
        });
        this.set('continentsAreas', continentsLowAreas);
    },

    didInsertElement: function(){
        this.$('#mapdiv').height(Ember.$('.corpus-app-container').height());
        this.createAmMap();
    },

    createAmMap: function() {
        console.log('createAmMap');
        var self = this;

        this.setContinentsAreas();
        this.set('map', AmCharts.makeChart('mapdiv', {
            'type': 'map',
            'fontFamily': 'sans-serif',
            'fontSize': '12px',
            'dragMap': false,
            'zoomOnDoubleClick': false,
            'language': 'fr',

            'areasSettings': {
                'autoZoom': false,
                'selectable': true,
                'color': '#becfd4',
                'colorOutline': '#253946',
                'selectedColor': '#253946',
                'rollOverOutlineColor': '#253946'
            },

            'zoomControl': {
                'zoomControlEnabled': false,
            },

            'dataProvider': {
                'mapVar': this.get('continentsMapVar'),
                'areas': this.get('continentsAreas')
            },

            listeners: [{
                'event':'clickMapObject',
                'method': Ember.run.bind(this, 'clickMapObject')
            },
            {
                'event':'homeButtonClicked',
                'method': Ember.run.bind(this, 'homeButtonClicked')
            }]
        }));
    },

    clickMapObject: function(event) {
        this.set('locationId', event.mapObject.id);
        this.sendAction('area', event.mapObject.id);
        this.get('filter').set('location', event.mapObject.title);
    },

    homeButtonClicked: function(event) {
        if(event.chart.dataProvider.map !== 'continentsLow') {
            this.sendAction('area', 'world');
        }
    }

});
