import Ember from 'ember';

export default Ember.Route.extend({

    area: 'world',

    model: Ember.observer('area', function() {
        var self = this;
        var promise = this.store.query('geostat', {
            'areas': self.get('area')
        });
        promise.then(function(value) {
            self.controllerFor('tabs/carto').set('areas', value.get('content'));
        });
        return promise;
    }),

    actions: {
        setAreaParameter: function(id) {
            this.set('area', id);
        }
    }

});
