import Ember from 'ember';

export default Ember.Route.extend({

    model: function() {
        return this.store.findAll('document');
    },

    serializeQueryParam: function(value, urlKey) {
        if (urlKey === 'date') {
            return value;
        }
        return '' + value;
    },

    deserializeQueryParam: function(value, urlKey) {
        if (urlKey === 'date') {
            var array = [];
            for (var i = 0; i < value.length; i++) {
                array.push(value[i]);
            }
            return array;
        }
        return value;
    },

    actions: {

        willTransition: function() {
            // Prevent navigation from removing query parameters
            var _this = this,
                queryParams = {};
            this.controller.get('queryParams').map(function(parameter){
                if(typeof parameter === 'object') {
                    Object.keys(parameter).forEach(function(value) {
                        queryParams[value] = _this.controller.get(value);
                    });
                } else {
                    queryParams[parameter] = _this.controller.get(parameter);
                }
            });
            this.transitionTo({ queryParams: queryParams });
        },

        didTransition: function() {
            // Append body classname depending on the route
            Ember.$('body').removeClass((this.controller.get('currentPath') || '').replace(/\//g, '-').dasherize());
            Ember.run.once(this, function() {
                Ember.$('body').addClass((this.controller.get('currentPath') ||'').replace(/\//g, '-').dasherize());
            });
        }

    }

});
